/*** INCLUDE BIBLIOTHEQUES ***/
#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include <string>
#include <sstream>
#include <map>


using namespace std;

/*** GLOBAL VARIABLES ***/
I2C i2c(PB_9, PB_8);
Adafruit_SSD1306_I2c oled(i2c,PC_13); 


/*** FUNCTIONS DECLARATIONS ***/
void OLED_writeString(string str, int x, int y);
void OLED_drawSmile();
void OLED_drawIdle();
void OLED_drawSleep(int);
void OLED_drawDead();


/*** Main***/
int main() 
{
  oled.clearDisplay();
  oled.splash(); oled.display(); wait(10); 
  oled.setTextSize(1); // changer la taille de text
  OLED_writeString("hello world", 32 , 12);// x , y la position de de but de l'écritude et la taille de l'ecran est 128x32 
  oled.clearDisplay();
  while(1){ }
}















void OLED_writeString(string str, int x, int y) {
  oled.setTextCursor(x, y);
  oled.fillRect(x, y, 128, 8, 0); // int16_t x, int16_t y, int16_t w, int16_t h, uint16_t color
  for (int i = 0; i < str.length(); i++) {
    oled.writeChar(str[i]);
  }

  oled.display();
}






void OLED_drawSmile() {
  oled.clearDisplay();
  oled.drawCircle(12, 20, 9, 1);
  oled.fillRect(0, 5, 22, 15, 0);
  oled.fillTriangle(2, 15, 10, 15, 6, 7, 1);
  oled.fillTriangle(3, 15, 9, 15, 6, 8, 0);
  oled.fillTriangle(14, 15, 22, 15, 18, 7, 1);
  oled.fillTriangle(15, 15, 21, 15, 18, 8, 0);
  oled.clearDisplay();
  oled.setTextSize(1.5);
  OLED_writeString("please place your hand", 1, 1);
}


void OLED_drawIdle() 
{
  oled.clearDisplay();
  oled.drawCircle(12, 20, 9, 1);
  oled.fillRect(0, 5, 22, 15, 0);
  oled.fillRect(7, 6, 2, 10, 1);
  oled.fillRect(16, 6, 2, 10, 1);
  oled.setTextSize(2);
  OLED_writeString("All ok!", 40, 10);
}


void OLED_drawSleep(int animationSwitch) {
  oled.clearDisplay();
  oled.drawCircle(10, 23, 3, 1);
  oled.fillRect(2, 12, 8, 2, 1);
  oled.fillRect(15, 12, 8, 2, 1);
  oled.setTextSize(1);
  OLED_writeString("z", 35, 16 + animationSwitch * 3);
  oled.setTextSize(2);
  OLED_writeString("z", 45, 11 - animationSwitch * 3);
  oled.setTextSize(3);
  OLED_writeString("z", 65, 6 + animationSwitch * 3);
  oled.setTextSize(4);
  OLED_writeString("z", 90, 1 - animationSwitch * 3);
  wait(1);
}


void OLED_drawDead() {
  oled.clearDisplay();
  oled.drawCircle(13, 27, 7, 1);
  oled.fillRect(0, 28, 22, 15, 0);
  oled.drawLine(2, 15, 10, 7, 1);
  oled.drawLine(2, 7, 10, 15, 1);
  oled.drawLine(16, 15, 24, 7, 1);
  oled.drawLine(16, 7, 24, 15, 1);
  oled.setTextSize(2);
  OLED_writeString("Heelp!", 40, 6);
  oled.setTextSize(1);
  OLED_writeString("Need water!!", 40, 22);
}


