//Includes
#include "mbed.h"
#include "LIS3DH.h"
#include "USBSerial.h"
//Accelerometer
#define MOSI PC_12
#define MISO PC_11
#define CS PC_5
#define SCLK PC_10
//Interrupt input
InterruptIn userb(PC_13); //User1
//PWM output
PwmOut PWMoutput(PB_1); //Main PWM output
PwmOut Green(PC_8); //PWM Red LED
PwmOut Red(PC_6); //PWM Green LED
PwmOut Blue(PC_9); //PWM Blue LED
//USART
USBSerial pc(0x1f00, 0x2012, 0x0001, false);
//USBSerial pc; //TX, RX
//Init accelerometer
LIS3DH acc(MOSI, MISO, SCLK, CS, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_2G);
double accX, accY, accZ;
bool interrupt;
// Clear the screen
void clrscr ()
{
    char clrscr[] = {0x1B, '[', '2', 'J', 0};
    pc.printf(clrscr);
}
//Home the cursor
void homescr()
{
    char homescr[] = {0x1B, '[', 'H', 0};
    pc.printf(homescr);
}
//goto specified line an column
void gotoscr(int line, int column)
{
    char scr[] = {0x1B, '[', 0x00,';',0x00, 'H', 0};
    scr[2] = line;
    scr[4] = column;
    pc.printf(scr);
}
//Interruption
void pressed(void)
{
    interrupt = 1;
}
//Main program
int main(int, char**)
{
    userb.fall(&pressed); // When button is pressed
    interrupt = 0;
    while (1) {
        accX = float(short((acc.read_reg(LIS3DH_OUT_X_H) << 8) | acc.read_reg(LIS3DH_OUT_X_L))) * 0.001F / 15;
        accY = float(short((acc.read_reg(LIS3DH_OUT_Y_H) << 8) | acc.read_reg(LIS3DH_OUT_Y_L))) * 0.001F / 15;
        accZ = float(short((acc.read_reg(LIS3DH_OUT_Z_H) << 8) | acc.read_reg(LIS3DH_OUT_Z_L))) * 0.001F / 15;
        Red = 10 * abs(accX / 255.0f);
        Green = 10 * abs(accY / 255.0f);
        Blue = 10 * abs(accZ / 255.0f);
        clrscr();
        homescr();
        // printf("\033[2J");
//Print accelerations values
        gotoscr('0','0');
        pc.printf("X acceleration = ");
        pc.printf("%5.2f",accX);
        gotoscr('2','0');
        pc.printf("Y acceleration = ");
        pc.printf("%5.2f",accY);
        gotoscr('3','0');
        pc.printf("Z acceleration = ");
        pc.printf("%5.2f",accZ);
        wait(0.5);

        if(interrupt == 1) {
            interrupt = 0;
            //  printf("\033[2J");
            clrscr();
            homescr();
            gotoscr('0','0');
            pc.printf("Interrupt button pressed");
            Red = 0 ;
            Green = 127 ;
            Blue = 0 ;
            wait(5);
        }
    }
}






/*//Includes

#include "mbed.h"

#include "LIS3DH.h"

//Accelerometer

#define MOSI PC_12
#define MISO PC_11
#define CS PC_5
#define SCLK PC_10


// GPIO set

//Interrupt input

//PWM output

PwmOut PWMoutput(PB_1);          //Main PWM output
PwmOut Green(PC_8);              //PWM Red LED
PwmOut Red(PC_6);                //PWM Green LED
PwmOut Blue(PC_9);               //PWM Blue LED

//USART

//USBSerial terminal;      //TX, RX

//Init accelerometer

LIS3DH      acc(MOSI, MISO, SCLK, CS, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_2G);

//Main program

int main(int, char**) {

 float x, y, z;

    while (1) {
    x = float(short((acc.read_reg(LIS3DH_OUT_X_H) << 8) | acc.read_reg(LIS3DH_OUT_X_L))) * 0.001F / 15;
    Red = sqrt(x*x)/4;
    y = float(short((acc.read_reg(LIS3DH_OUT_Y_H) << 8) | acc.read_reg(LIS3DH_OUT_Y_L))) * 0.001F / 15;
    Green = sqrt(y*y)/4;
    z = float(short((acc.read_reg(LIS3DH_OUT_Z_H) << 8) | acc.read_reg(LIS3DH_OUT_Z_L))) * 0.001F / 15;
    Blue = sqrt(z*z)/4;
    wait(0.1);

    }
}
*/