

// This program use SimpleBLE and X_NUCLEO_IDB0XA1 librairies, don't forget to includ it !!!

#include "mbed.h"
#include "SimpleBLE.h"



    //Name of the brodcasted BLE
    
SimpleBLE ble("ObCP_ENSMM_CROC");

const int addr = 0x90;      // define the I2C Address for TC74-A0 1001 000 0<-- R/W bit

    // GPIO set

    //Interrupt input

InterruptIn user3(PC_13);  //User3
InterruptIn user2(PC_12);  //User2
InterruptIn user1(PC_11);  //User1

    //Analog input

AnalogIn  analog_value(PA_5);     //Analog input value
AnalogIn  current(PA_4);          //PWM output current
AnalogIn  analog_temp(PC_4);      //Analog temp sensor

    //PWM output

PwmOut PWMoutput(PB_8);          //Main PWM output
PwmOut Green(PB_5);              //PWM Red LED
PwmOut Red(PB_4);                //PWM Green LED
PwmOut Blue(PB_0);               //PWM Blue LED

    //USART

Serial terminal(PA_2, PA_3);      //TX, RX

    //I2C Temp sensor

I2C TC74(PB_7, PB_6);           //TC74 temp sensor I2C sda, scl


    // Characteristic input
SimpleChar<uint8_t> input = ble.readOnly_u8(0xA000, 0xA002);

    // When characteristic LED RGB changing
void LEDupdate(uint32_t newColor) {
    
    // read individual bytes
    uint8_t* channels = (uint8_t*)&newColor;

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    Red   = static_cast<float>(channels[0]) / 255.0f;
    Green = static_cast<float>(channels[1]) / 255.0f;
    Blue  = static_cast<float>(channels[2]) / 255.0f;
}

    // When characteristic PWM output changing

void PWMupdate(uint8_t pwmvalue) {
    
    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    PWMoutput   = static_cast<float>(pwmvalue) / 255.0f;
    
}

// When characteristic input changing
void Inputupdate() {
    
                        TC74.start();                //Start condition
                        TC74.write(addr|1);          //Device Adress read mode
                        input = TC74.read(0);        //Temp register value reading
                        TC74.stop();                 //I2C stop                                                                                             
    
}

// Characteritic PWM LED RGB
SimpleChar<uint32_t> color = ble.writeOnly_u32(0x6200, 0x6201, &LEDupdate);

// Characteristic PWM output
SimpleChar<uint8_t> pwmout = ble.writeOnly_u8(0xA000, 0xA001, &PWMupdate);


//Main program

int main(int, char**) {
      
    ble.start();
    Ticker t;
    t.attach(&Inputupdate, 5.0f);
    
    while (1) {
        
        ble.waitForEvent();
    }
}
