#include "LSM9DS1.h"
#include "MadgwickUpdate.h"

#include "USBSerial.h"
USBSerial pc(0x1f00, 0x2012, 0x0001, false);
Timer t;
int lastPrint = 0;
int printInterval = 3;
// https://github.com/kriswiner/LSM9DS1/blob/master/LSM9DS1_MS5611_BasicAHRS_t3.ino
int main()
{

    wait(1);
    pc.printf("HOLLA ! .\n");
    LSM9DS1 lol(PB_9, PB_8, 0xD4, 0x38);
    t.start();
    lol.begin();
    if (!lol.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    lol.calibrate();
    while(1) {
        firstUpdate = t.read_ms();
        lastUpdate = firstUpdate;
        q[0] = 1.0f;q[1] = 0.0f;q[2] = 0.0f;q[3] = 0.0f;
        if ( lol.accelAvailable() || lol.gyroAvailable() ) {

            lol.readAccel();
            lol.readGyro();

            Now = t.read_ms();
            deltat = (float)((Now - lastUpdate)/1000000.0f);
            lastUpdate = Now;

            float ax = lol.calcAccel(lol.ax);float ay = lol.calcAccel(lol.ay);float az = lol.calcAccel(lol.az);
            float gx = lol.calcGyro(lol.gx);float gy = lol.calcGyro(lol.gy);float gz = lol.calcGyro(lol.gz);
            float mx = lol.calcMag(lol.mx);float my = lol.calcMag(lol.my);float mz = lol.calcMag(lol.mz);
            // switch x and y to convert to right handed coordinate system
            //MadgwickQuaternionUpdate( ay, ax, az, gy*PI/180.0f, gx*PI/180.0f, gz*PI/180.0f );

            int nowMs = t.read_ms();
            if( nowMs - lastPrint > printInterval ) {
                lastPrint = nowMs;
                //pc.printf("gyro: %f %f %f\n\r", gx, gy, gz);
                //pc.printf("accel: %f %f %f\n\r", ax, ay, az);
                //pc.printf("quat: %f %f %f %f\n\r", q[0], q[1], q[2], q[3]);
                pc.printf("%d %f,%f,%f,%f,%f,%f\n",nowMs,ax,ay,az,gx,gy,gz);

            }
        }
    }
}

