 //Includes
#include "mbed.h"
Timer timer;
#include "USBSerial.h"

#define I2C_SDA                  PB_9           // The µcontrolleur SDA 
#define I2C_SCL                  PB_8           // The µcontrolleur SCL


int Intervalle_Mesures = 300;      //Choix de l'intervalle de mesure en sec

//Interrupt input
InterruptIn button(PC_13); //User1

//USART
USBSerial pc(0x1f00, 0x2012, 0x0001, false);


//Voie I2C du F411
I2C i2c(I2C_SDA, I2C_SCL);

//Variables

float tmp;
char cmd[2];

//Main program
int main(){
    
    timer.start();
    float time, time1;
    
    time = timer.read_ms()/1000;
    
    pc.printf("Initialiation...\t");
    cmd[0] = 0x01;
    cmd[1] = 0x00;
        
    i2c.write(0x91, cmd, 2);
    cmd[0] = 0x00;
    i2c.write(0x91, cmd, 1);
    
    pc.printf("Initialiation OK\t");
    
    cmd[0] = 0;
    cmd[1] = 0;
    while (button == 1) {
        time1 = timer.read_ms()/1000;
        
        if (time1-time>Intervalle_Mesures){
            i2c.read(0x90, cmd, 2);
        
            float x = float(cmd[0])*2;
            float y = float(cmd[1])*0.0078125;
            tmp = x + y;
            pc.printf("%0.2f", tmp);
            
            time=timer.read_ms()/1000;
            time1=timer.read_ms()/1000;
        }
    }
}
        
        
    
