/*----------------------------------------------------------------------------
I2C interface
SERIAL COMMUNICATION
*/

#include "mbed.h"
#include "pindef.h"

//I2C interface
I2C temp_sensor(I2C_SDA, I2C_SCL);
Serial pc(UART_TX, UART_RX);

//I2C address of temperature sensor
const int temp_addr = 0x92;

char cmd[] = {0x51, 0xAA};
char read_temp[2];

/*----------------------------------------------------------------------------
 MAIN function
 *----------------------------------------------------------------------------*/

int main(){
    while(1){
        /*
        Write the Start Convert T command to the sensor
        Write the Read Temperature command to the sensor
        Read the 16-bit temperature data
        */
        
        //Write your code here
        

        temp_sensor.write(10010010, &cmd[0], 0);
        wait(0.5);
        temp_sensor.write(10010010, &cmd[1], 0);
        temp_sensor.read(10010011, read_temp, 1);
       
         
        //Convert temperature to Celsius
        float temp = (float((read_temp[0] << 8) | read_temp[1]));
        
        //Print temperature to the serial monitor
        
        //Write your code here
        pc.printf(" Temperature reading is: %f Celsius \r\n", temp );
        pc.printf("Method 2 Temp = %d\n\r", read_temp[1]);
        
        
        
    }
}

// *******************************ARM University Program Copyright (c) ARM Ltd 2014*************************************
