#include "mbed.h"
PwmOut PWM(D3);         //Sortie PWM
DigitalIn button(D2);   //Entrée digitale Boutton
DigitalOut led(LED1);   //Sortie digitale LED

double pwm_value;
double pwm_max_value;
double pwm_step;

int main()
{
    pwm_value = 0;          //Initialisation PWM
    pwm_max_value = 0.4;   //Initialisation max PWM
    pwm_step = 0.001;       //Initialisation pas PWM
    PWM.period_ms(1);       // Période de la sorti PWM
    PWM.write(0);           //Moteur désactivée

    while(1) {
        if(button == 1) {
            led=!led;                           //Flip LED

            while(pwm_value < pwm_max_value) {  //Rampe ascendante de la commande de vitesse du moteur
                pwm_value += pwm_step;          //Incrémentation du rapport cyclique (%) de la valeur du pas
                PWM.write(pwm_value);           //Application du nouveaun rapport cyclique
                wait(pwm_step);                 //Attente de la valeur du pas
            }

            wait(3);                            //Attente 3 secondes sur le plateau de vitesse

            while(pwm_value > 0) {              //Rampe descendante de la commande de vitesse du moteur
                pwm_value -= pwm_step;          //Décrémentation du rapport cyclique (%) de la valeur du pas
                PWM.write(pwm_value);           //Application du nouveaun rapport cyclique
                wait(pwm_step);                 //Attente de la valeur du pas
            }

            led = !led;                         //Flip Led
        }
    }
}

