//Includes

#include "mbed.h"
#include "SimpleBLE.h"
#include "USBSerial.h"
#include "SDFileSystem.h"

//declaration des sortie entrées 
SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd"); // carte sd 
FILE *fp= fopen("/sd/valeur_ble.txt", "a"); // fichier carte sd 
SimpleBLE ble("ObCP_Baton ");// Bleutooth  
USBSerial pc; // Bouton d’interruption
InterruptIn button1(PC_13); // Bouton d’interruption 

//declaration des variables

int  height=0; bool interruption= false;char name[50]; int i= 0 ;  int weight; int age ; char gender[1]; int max_heart_rate; bool message_envoyee= false; 

//declaration des fonctions 
void fct_name_text(uint8_t newState); 
void fct_height_int(uint8_t newState); 
void fct_weight_int(uint8_t newState); 
void fct_age_int(uint8_t newState);
void fct_gender_text(uint8_t newState); 
void fct_max_heart_rate_int(uint8_t newState); 
void fct_fini(uint8_t newState); 


void fct_interruption_ble();


SimpleChar<uint8_t> name_text =        ble.writeOnly_u8(0x8600, 0x8601, &fct_name_text); 
SimpleChar<uint8_t> height_int =       ble.writeOnly_u8(0x8600, 0x8602, &fct_height_int); 
SimpleChar<uint8_t> weight_int=        ble.writeOnly_u8(0x8600, 0x8603, &fct_weight_int); 
SimpleChar<uint8_t> age_int=           ble.writeOnly_u8(0x8600, 0x8604, &fct_age_int);
SimpleChar<uint8_t> gender_text=       ble.writeOnly_u8(0x8600, 0x8605, &fct_gender_text);
SimpleChar<uint8_t> max_heart_rate_u8= ble.writeOnly_u8(0x8600, 0x8606, &fct_max_heart_rate_int);
SimpleChar<uint8_t> fini = ble.writeOnly_u8(0x8600, 0x8607, &fct_fini);

int main(int, char**)
{   
    ble.start();button1.fall(&fct_interruption_ble);
    fprintf(fp,"\n********************************Bonjour**************************************\n"); 
    while (1) {
    while (interruption== true) 
    { 
        if ( message_envoyee== true ) 
        {   
            fprintf(fp,"\n********************************BLE**************************************\n"); 
            fprintf(fp,"name: %s ; ",name);   
            fprintf(fp,"height: %d  ;",height);
            fprintf(fp,"weight: %d  ;",weight);
            fprintf(fp,"age: %d  ;",age);
            fprintf(fp,"gender: %s  ;",gender); 
            fprintf(fp,"max_heart_rate: %d  ;",max_heart_rate);
            fprintf(fp,"\n********************************BLE-fin**************************************\n");
            message_envoyee= false;interruption= false;
          }
          else
          {
              ble.waitForEvent(); }
      }
      //pc.printf("doing something ..."); wait(1); 
      }
}

void fct_name_text(uint8_t newState)  {   name[i] = (char) newState; i= i+1 ;pc.printf("name %s  ",name);}
void fct_height_int(uint8_t newState)  {  height = (int) newState;pc.printf("height %d  ",height); }
void fct_weight_int(uint8_t newState)  {  weight = (int) newState;pc.printf("weight %d  ",weight); }
void fct_age_int(uint8_t newState)  {  age = (int) newState;pc.printf("age %d  ",age); }
void fct_gender_text(uint8_t newState)  {  gender[0] = (char) newState;pc.printf("gender %s  ",gender); }
void fct_max_heart_rate_int(uint8_t newState)  {  max_heart_rate = (int) newState; pc.printf("max_heart_rate %d  ",max_heart_rate);}
void fct_fini(uint8_t newState) { message_envoyee= true;  pc.printf("message_envoyee "); } 

void fct_interruption_ble(){  interruption= true ;  height = 0; i=0; for (int j=1;j<50;j++){ name[j] = '_';} weight=0; age =0; char gender[1] = {'_'} ; max_heart_rate=0; message_envoyee= false; }
