#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/UARTService.h"
#include "Serial.h"
#include "stdlib.h"

#define UART_BUFFER (UARTService::BLE_UART_SERVICE_MAX_DATA_LEN)


const static char DEVICE_NAME[] = "Mheuve";
UARTService *uartServicePtr;

//PWM output

DigitalOut Green(PC_4);              //Red LED
DigitalOut Red(PC_5);                //Green LED

Ticker tempo;

// Tableau et index de communication avec UART
static char uartBuff[UART_BUFFER];

// Routine de traitement des erreurs
void onBleError(ble_error_t error);

/****************************************************/
/* Ticker actif lorsque la connexion BLE est présente */
/****************************************************/
void ConnectedBLE(void)
{
    // Signal de vie: allumer et éteindre la LED
     Red = 0;
    Green = 1 ;

}

void message(void)
{
    //Integre les trois chaines de caractere contenant les accelerations dans la chaine uartBuff
    sprintf(uartBuff, "coucou") ;
    //Envoie la chaine uartBuff sur le sevice TX UART BLE
    uartServicePtr->write(uartBuff, UARTService::BLE_UART_SERVICE_MAX_DATA_LEN);
    // Réinitialiser la chaîne uartBuff en entrant 0 dans les premiers caractères UART_BUFFER
    memset(uartBuff, 0, UART_BUFFER);

}

/*************************/
/* Connexion BLE réussie */
/*************************/
void BleConnectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    // Signal de connexion BLE: allume / éteint la LED avec une période de 1 seconde
    ConnectedBLE();
    tempo.attach(message, 1);
}

/*****************************/
/* Déconnexion du client BLE */
/*****************************/
void BleDisconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    // Redémarrer la publicité
    tempo.detach();
    BLE::Instance().gap().startAdvertising();
    
    Green = 0;
    Red = 1;
    
}

/***************************/
/* Rx de BLE et Rx vers USB*/
/***************************/
void BleOnDataWrittenCallback(const GattWriteCallbackParams *params)
{
    char reception[UART_BUFFER];
    char commande[2];
    float valeur;

    // Reçoit une chaîne de BLE
    if (params->handle == uartServicePtr->getTXCharacteristicHandle()) {
        // Copie de la chaine reçue dans reception
        sprintf(reception,"%s", params->data);
        // Copie dans la chaine commande des deux premier caracteres de la chaine reception
        sprintf(commande,"%c%c", reception[0], reception[1]);
        // Transformation des 3 caracteres suivants en valeur numerique
        valeur = ((reception[2] - '0')* 100 + (reception[3] - '0')* 10 +(reception[4] - '0')) ;
        valeur = valeur/255;
                
        if( strcmp(commande, "LR")==0) {
            
        }
        if( strcmp(commande, "LV")==0) {
            
        }  

    }
}

/***************************/
/* Erreur sur le canal BLE */
/***************************/

void onBleError(ble_error_t error)
{
    Red = 1;  
    
    /* Entrer le traitement des erreurs */
}

/**************************************/
/* Initialisation du service BLE UART */
/**************************************/

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {

        /* En cas d'erreur, transmettez le traitement d'erreur à onBleInitError*/
        onBleError(error);
        return;
    }

    /* Assurez-vous qu'il s'agit de l'instance par défaut de BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onConnection(BleConnectionCallback);
    ble.gap().onDisconnection(BleDisconnectionCallback);
    ble.gattServer().onDataWritten(BleOnDataWrittenCallback);

    /* Configuration du service primaire. */
    UARTService uartService(ble);
    uartServicePtr = &uartService;

    /* Configurer la publicité */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(500); /* 500ms. */
    ble.gap().startAdvertising();

    // Attend les événements sur BLE
    while (true) {
        ble.waitForEvent();
    }
}

/********/
/* MAIN */
/********/
int main(void)
{

    // Initialiser LED
    Green = 0;
    Red = 1;
  


    /****** START Initialiser BLE **********/
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    /******* FIN initialise BLE ***********/

}

