#include "mbed.h"

SPI spi(PB_5, PB_4, PB_3); // mosi, miso, sclk
DigitalOut cs(PA_1);
Serial pc(USBTX, USBRX);
DigitalOut led(LED1);

#define DTIME 0.005

int main()
{
    cs = 1;
    spi.format(8,0);
    spi.frequency(1000000);
    led = 0;

    while(1) {
        led = 1;        
        cs=0;
        wait(DTIME);
        int byte_1 = spi.write(0x03);
        pc.printf("byte_1: %d ",byte_1);
        cs=1;

        cs=0;
        wait(DTIME);
        int byte_2 = spi.write(0xFF);
        pc.printf("byte_2: %d ",byte_2);
        cs=1;
        
        cs=0;
        wait(DTIME);
        int byte_waste = spi.write(0xFF);
        cs=1;

        int rbyte = (byte_1<<8)+byte_2;
        pc.printf("rbyte: %d\r\n",rbyte);
        led = 0;
        
        wait(0.05);
    }

}