#ifndef SENSOR_H
#define SENSOR_H

#include "mode.h"

#ifdef SIMPLE_BIOLOID_MODE
#define PRESSURE_SENSOR_FOOTDEVICE_MODULUS 284     //フット装置側 圧力センサ係数 a*e^xのa
#define PRESSURE_SENSOR_BIOLOID_MODULUS 8       //バイオロイド側 圧力センサ係数 a*e^xのa 8
#define PRESSURE_SENSOR_FOOTDEVICE_LOG 3.43f    //フット装置側 圧力センサ指数 a*e^xのx
#define PRESSURE_SENSOR_BIOLOID_LOG 6.1f       //バイオロイド側 圧力センサ指数 a*e^xのx 6.1f

#define DIAMETER_PRESSURE_FOOTDEVICE 20.0f   //フット装置の与圧部直径 mm
#define DIAMETER_PRESSURE_FOOT 6.0f         //バイオロイド与圧部直径 mm
#endif

#ifdef HUMAN_TO_HUMAN_MODE
#define PRESSURE_SENSOR_FOOTDEVICE_MODULUS 284     //フット装置側 圧力センサ係数 a*e^xのa
#define PRESSURE_SENSOR_BIOLOID_MODULUS 284       //バイオロイド側 圧力センサ係数 a*e^xのa 8
#define PRESSURE_SENSOR_FOOTDEVICE_LOG 3.43f    //フット装置側 圧力センサ指数 a*e^xのx
#define PRESSURE_SENSOR_BIOLOID_LOG 3.43f       //バイオロイド側 圧力センサ指数 a*e^xのx 6.1f

#define DIAMETER_PRESSURE_FOOTDEVICE 20.0f   //フット装置の与圧部直径 mm
#define DIAMETER_PRESSURE_FOOT 20.0f         //バイオロイド与圧部直径 mm
#endif



class Sensor{
    private:
        float value;
        float offset_position;
        float epsilon;
    public:
        int id;
        float pressure_sensor_modulus;
        float pressure_sensor_log;
        float skin_elastic;
        float area_pressure;
        
        float Getvalue();
        float Getvalue_bio();
        float Getforce();
        float Getforce_bio();
        float Getstress();
        float Getposition();
        float Getoffset();
        float Getdistance();
        float Getepsilon();
        void Update_offset();
        Sensor(int id, float pressure_sensor_modulus,float pressure_sensor_log, float diameter);   
};

extern Sensor sensor_blank_device;
extern Sensor sensor_toe_device;
extern Sensor sensor_thumball_device;
extern Sensor sensor_littleball_device;
extern Sensor sensor_arch_device;
extern Sensor sensor_heel1_device; //outer
extern Sensor sensor_heel2_device; //inner
extern Sensor sensor_foot_device[7];

extern Sensor sensor_blank;
extern Sensor sensor_toe;
extern Sensor sensor_thumball;
extern Sensor sensor_littleball;
extern Sensor sensor_arch;
extern Sensor sensor_heel1; //outer
extern Sensor sensor_heel2; //inner
extern Sensor sensor_foot[7];

#endif