#include "mbed.h"
#include "sensor.h"
#include "param.h"
#include "motor.h"
#include "control.h"


/****ふっと装置側センサ****/
AnalogIn f0(PA_0);  //toe
AnalogIn f1(PA_1);  //thum-ball
AnalogIn f2(PA_4);  //little-ball
AnalogIn f3(PB_0);  //outer-foot-arch
AnalogIn f4(PC_1);  //heel1 outer
AnalogIn f5(PC_0);  //heel2 inner
AnalogIn foot_device_sensor[6] = {
    f0,
    f1,
    f2,
    f3,
    f4,
    f5
};

/****足裏圧力センサ or Bioloidセンサ****/
AnalogIn f10(PC_3); //toe
AnalogIn f11(PC_2); //thum-ball
AnalogIn f12(PA_6); //little-ball
AnalogIn f13(PA_7); //outer-foot-arch
AnalogIn f14(PC_4); //heel1 outer
AnalogIn f15(PC_5); //heel2 inner
AnalogIn foot_sensor[6] = {
    f10,
    f11,
    f12,
    f13,
    f14,
    f15
};

float Sensor::Getvalue()
{
    float value = 1 - foot_device_sensor[(this->id) - 1];
    return value;
}

float Sensor::Getvalue_bio()
{
    float value = 1 - foot_sensor[(this->id) - 1];
    return value;
}

float Sensor::Getforce()
{
    float force_value;
    if(this->Getvalue()==0) {
        force_value=0;
    } else {
        float log_value = exp(this->pressure_sensor_log *this->Getvalue());
        /*if(log_value<1) {
            force_value*=-1;
        } else {*/
            force_value = this->pressure_sensor_modulus *log(log_value); //g
        //}
    }
    return force_value;
}

float Sensor::Getforce_bio()
{
    float force_value;
    if(this->Getvalue_bio()==0) {
        force_value=0;
    } else {
        float log_value = exp(this->pressure_sensor_log *this->Getvalue_bio());
        /*if(log_value<1) {
            force_value*=-1;
        } else {*/
            force_value = this->pressure_sensor_modulus *log(log_value); //g
        //}
    }
    return force_value;
}

float Sensor::Getstress()
{
    float stress = this->Getforce() / this->area_pressure;
    return stress;
}

float Sensor::Getposition()
{
    int enc = read_enc(this->id);
    return convert_angle_to_distance(convert_enc_to_angle(enc));
}

float Sensor::Getoffset()
{
    return this->offset_position;
}

float Sensor::Getdistance()
{
    return this->Getposition() - this->Getoffset();
}

float Sensor::Getepsilon()
{
    static float old_distance = 0;
    this->epsilon = (this->Getoffset() - old_distance)/this->Getoffset();
    old_distance = this->Getdistance();
    return this->epsilon;
}

void Sensor::Update_offset()
{
    this->offset_position = this->Getposition();
    #ifndef ROS_MODE
    //printf("[id: %d]'offset = %f\r\n",this->id, this->offset_position);
    #endif
}

Sensor::Sensor(int id, float pressure_sensor_modulus, float pressure_sensor_log, float diameter)
{
    this -> id = id;
    this -> pressure_sensor_modulus = pressure_sensor_modulus;
    this -> pressure_sensor_log = pressure_sensor_log;
    this -> area_pressure = diameter*diameter*PI/4;
    #ifndef ROS_MODE
    //printf("pressure sensor %d instance is created\r\n", id);
    #endif
}

/******** フット装置側センサ インスタンス ********/
Sensor sensor_blank_device(0, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);
Sensor sensor_toe_device(1, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);
Sensor sensor_thumball_device(2, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);
Sensor sensor_littleball_device(3, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);
Sensor sensor_arch_device(4, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);
Sensor sensor_heel1_device(5, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);
Sensor sensor_heel2_device(6, PRESSURE_SENSOR_FOOTDEVICE_MODULUS,PRESSURE_SENSOR_FOOTDEVICE_LOG,DIAMETER_PRESSURE_FOOTDEVICE);

Sensor sensor_foot_device[7] = {
    sensor_blank_device,
    sensor_toe_device,
    sensor_thumball_device,
    sensor_littleball_device,
    sensor_arch_device,
    sensor_heel1_device,
    sensor_heel2_device
};

/******** 足裏 or Bioloid側センサ インスタンス ********/
Sensor sensor_blank(0, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_toe(1, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_thumball(2, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_littleball(3, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_arch(4, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_heel1(5, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_heel2(6, PRESSURE_SENSOR_BIOLOID_MODULUS,PRESSURE_SENSOR_BIOLOID_LOG,DIAMETER_PRESSURE_FOOT);
Sensor sensor_foot[7] = {
    sensor_blank,
    sensor_toe,
    sensor_thumball,
    sensor_littleball,
    sensor_arch,
    sensor_heel1,
    sensor_heel2
};