#include "mbed.h"
#include "save_data.h"
#include "sensor.h"
#include "init.h"
#include "mode.h"

int time_data;
int time_flag;
int save_data_num = 0;
bool print_flag = 0;
Timer t_print;

#ifndef ROS_MODE
Ticker t;
#endif
//val = name.read();
//name.reset();
//name.stop();
//name.start();
float temp_foot_device_data[NUM_DATA][11] = {0};
float elapsed_time = 0;

void start_ticker()
{
#ifdef TEMPORARY_MODE
    t.attach(&temporary_save_data, SAMPLING_TIME);
#endif
#ifdef REALTIME_MODE
    print_flag = 1;
#endif
}

void temporary_save_data()
{
    //printf("%d\r\n",save_data_num);
#ifdef TEMPORARY_MODE
    float elapsed_time = save_data_num * SAMPLING_TIME;

    //printf("%f",t.read());
    //printf("%f,%d, ",elapsed_time,save_data_num);

    if(NUM_DATA<=save_data_num) {
        //save_data_num=0;
        time_flag = 1;
    } else {
        temp_foot_device_data[save_data_num][0] = elapsed_time;

        temp_foot_device_data[save_data_num][1] = sensor_foot_device[1].Getvalue();
        temp_foot_device_data[save_data_num][2] = sensor_foot[1].Getvalue_bio();

        temp_foot_device_data[save_data_num][3] = sensor_foot_device[2].Getvalue();
        temp_foot_device_data[save_data_num][4] = sensor_foot[2].Getvalue_bio();

        temp_foot_device_data[save_data_num][5] = sensor_foot_device[3].Getvalue();
        temp_foot_device_data[save_data_num][6] = sensor_foot[3].Getvalue_bio();

        temp_foot_device_data[save_data_num][7] = sensor_foot_device[4].Getvalue();
        temp_foot_device_data[save_data_num][8] = sensor_foot[4].Getvalue_bio();

        temp_foot_device_data[save_data_num][9] = sensor_foot_device[5].Getvalue();
        temp_foot_device_data[save_data_num][10] = sensor_foot[5].Getvalue_bio();
    }
    save_data_num++;

    if(time_flag == 1) {
        //printf("finish");
        t.detach();
    }
#endif
}

void view_save_data(int save_data_num)
{
#ifdef TEMPORARY_MODE
    //printf("data number:%d\r\n",save_data_num);
    wait(1);
    for(int i=0; i<save_data_num; i++) {
        if(temp_foot_device_data[i][0]==0) {}
        else {
            //printf("%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n",
                   temp_foot_device_data[i][0],
                   temp_foot_device_data[i][1],temp_foot_device_data[i][2],
                   temp_foot_device_data[i][3],temp_foot_device_data[i][4],
                   temp_foot_device_data[i][5],temp_foot_device_data[i][6],
                   temp_foot_device_data[i][7],temp_foot_device_data[i][8],
                   temp_foot_device_data[i][9],temp_foot_device_data[i][10]
                  );
        }
    }
    //printf("save finish!\n\r");
    while(1);
#endif
}

void print_data(bool print_flag)
{
#ifdef REALTIME_MODE
    static float elapsed_time=0;

    if(print_flag) {
        save_data_num++;

        t_print.reset();
        t_print.start();

        for(int i=1; i<NUM_LINEAR+1; i++) {
            temp_foot_device_data[0][2*i-1] = sensor_foot_device[i].Getvalue();
            temp_foot_device_data[0][2*i] = sensor_foot[i].Getvalue_bio();

            if(temp_foot_device_data[0][2*i-1]==1) {
                temp_foot_device_data[0][2*i-1] = temp_foot_device_data[1][2*i-1];
            } else {
                temp_foot_device_data[1][2*i-1] = temp_foot_device_data[0][2*i-1];
            }
            if(temp_foot_device_data[0][2*i]==1) {
                temp_foot_device_data[0][2*i] = temp_foot_device_data[1][2*i];
            } else {
                temp_foot_device_data[1][2*i] = temp_foot_device_data[0][2*i];
            }
        }

        //printf("%f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\r\n",
               elapsed_time,
               temp_foot_device_data[0][1],temp_foot_device_data[0][2],
               temp_foot_device_data[0][3],temp_foot_device_data[0][4],
               temp_foot_device_data[0][5],temp_foot_device_data[0][6],
               temp_foot_device_data[0][7],temp_foot_device_data[0][8],
               temp_foot_device_data[0][9],temp_foot_device_data[0][10]
              );

        t_print.stop();
        elapsed_time += t_print.read();
    } else ;
#endif
}
