#include "mbed.h"
#include <ros.h>
#include <std_msgs/Float32.h>
#include <std_msgs/Float32MultiArray.h>
#include <std_msgs/Int32MultiArray.h>
#include "ros_main.h"
#include "run_foot.h"
#include "control.h"
#include "init.h"
#include "sensor.h"
#include "motor.h"
#include "vibration.h"
#include "param.h"
#include "save_data.h"
#include "mode.h"

#ifdef SIMPLE_BIOLOID_MODE
#define HUMAN_MASS      60.0f   //kg    人間
#define BIOLOID_MASS    2.0f    //kg    人間
#define RATIO_MASS HUMAN_MASS/BIOLOID_MASS  //(人間/バイオロイド)
#endif

#ifdef HUMAN_TO_HUMAN_MODE
#define HUMAN_MASS      60.0f   //kg    人間
#define BIOLOID_MASS    60.0f   //kg   人間
#define RATIO_MASS HUMAN_MASS/BIOLOID_MASS  //(人間/人間)
#endif

#define SKIN_ELASTIC 0.136f //MPa 圧縮弾性係数
#define HUMANFOOT_THIN 5 //mm

#define SAVE_MODE

DigitalIn button(PC_13);
Ticker run_foot_ticker;

std_msgs::Int32MultiArray test_msg;
ros::Publisher test_pub("test_topic", &test_msg);
int control_flag = 0;

void start_run_foot()
{
    //nh.initNode();
    //nh.advertise(test_pub);

//    test_msg.data_length = 7;
//    test_msg.data = (int *)malloc(sizeof(float)*14);
//    for(int i = 0; i < test_msg.data_length; i++) {
//        test_msg.data[i] = 0;
//    }

    run_foot_ticker.attach(&run_foot,0.02);//0.0005);
}

void run_foot()
{
    static float target_pressure[NUM_LINEAR+1] = {0};
    static float target_distance[NUM_LINEAR+1] = {0};
    static int output[NUM_LINEAR+1] = {0};
    static int repeat_row_number=0;
    static bool button_flag = 0;
    int temp_foot_data_device[NUM_LINEAR] = {0};
    int temp_foot_data_bio[NUM_LINEAR] = {0};
    for(int i=1; i<NUM_LINEAR+1; i++) {
        if(i==4 || i==6) {  //4番、6番の直動機構は使わない
            continue;
        }
        temp_foot_data_device[i] = sensor_foot_device[i].Getvalue()*1000;
        temp_foot_data_bio[i]    = sensor_foot[i].Getvalue_bio()*1000;

#ifndef ROS_FOOT_REPEAT_MODE
        //target_pressure[i] = RATIO_MASS * (sensor_foot[i].Getforce_bio() - sensor_foot_device[i].Getforce());
        //target_distance[i] = (sensor_foot[i].Getforce_bio()/(DIAMETER_PRESSURE_FOOT*DIAMETER_PRESSURE_FOOT*PI*SKIN_ELASTIC)) * HUMANFOOT_THIN;
        target_pressure[i] = RATIO_MASS * (temp_foot_data_bio[i] - temp_foot_data_device[i]);
        target_distance[i] = (sensor_foot[i].Getforce_bio()/(DIAMETER_PRESSURE_FOOT*DIAMETER_PRESSURE_FOOT*PI*SKIN_ELASTIC)) * HUMANFOOT_THIN;
#endif
#ifdef ROS_FOOT_REPEAT_MODE
        if(button==0) {
            button_flag = 1;
        }
        if(button_flag) {
            //repeat_foot_target[repeat_row_number] = repeat_foot_data[repeat_row_number];
            target_pressure[i] = RATIO_MASS * (repeat_foot_data[repeat_row_number][i] - temp_foot_data_device[i]);
            target_distance[i] = (sensor_foot[i].Getforce_bio()/(DIAMETER_PRESSURE_FOOT*DIAMETER_PRESSURE_FOOT*PI*SKIN_ELASTIC)) * HUMANFOOT_THIN;
        } else {
            target_pressure[i] = RATIO_MASS * (temp_foot_data_bio[i] - temp_foot_data_device[i]);
            target_distance[i] = (sensor_foot[i].Getforce_bio()/(DIAMETER_PRESSURE_FOOT*DIAMETER_PRESSURE_FOOT*PI*SKIN_ELASTIC)) * HUMANFOOT_THIN;
        }
#endif
        output[i] = control_foot(target_distance[i], 0, target_pressure[i], i);
        //foot_pressure_check(i);
        //move_motor(output[i],i);
    }

#ifdef ROS_FOOT_REPEAT_MODE
    for(int i=0; i<7; i++) {
        //test_msg.data[i] = repeat_foot_data[repeat_row_number][i];
        if(i==0)continue;
        repeat_foot_data[repeat_row_number][NUM_LINEAR + i] = temp_foot_data_device[i];
    }
    //test_msg.data[6]=button_flag;
    //test_msg.data[0]=repeat_row_number;
    //test_pub.publish(&test_msg);
    //nh.spinOnce();

    if(button_flag) {
        repeat_row_number++;
    }
    if(repeat_row_number>len_row_max-1) {
        repeat_row_number = 0;
        button_flag = 0;
        control_flag = 0;
        run_foot_ticker.detach();
    }

#endif

    move_motors(output);

#ifndef ROS_MODE
    if(button==0) {
        //printf("save timer start!\r\n");
        start_ticker();
    }

    if(time_flag==1) {
        view_save_data(save_data_num);
    }
#endif

}
