#include "mbed.h"
#include <ros.h>
#include <std_msgs/Float32.h>
#include <std_msgs/Float32MultiArray.h>
#include <std_msgs/Int32MultiArray.h>
#include <std_msgs/Int32.h>
#include "ros_main.h"
#include "init.h"
#include "sensor.h"
#include "mode.h"
#include "run_foot.h"

#ifdef RIGHT_MODE
#define FOOT_PRESSURE_TOPIC                     "foot_pressure_topic_R"
#define ROS_FOOT_REPEAT_DATA_ROW_NUMBER_TOPIC   "ros_foot_repeat_data_row_number_topic_R"
#define ROS_FOOT_REPEAT_DATA_TOPIC              "ros_foot_repeat_data_topic_R"
#define ROS_FOOT_DATA_ROW_NUMBER_TOPIC          "ros_foot_data_row_number_topic_R"
#endif

#ifdef LEFT_MODE
#define FOOT_PRESSURE_TOPIC                     "foot_pressure_topic_L"
#define ROS_FOOT_REPEAT_DATA_ROW_NUMBER_TOPIC   "ros_foot_repeat_data_row_number_topic_L"
#define ROS_FOOT_REPEAT_DATA_TOPIC              "ros_foot_repeat_data_topic_L"
#define ROS_FOOT_DATA_ROW_NUMBER_TOPIC          "ros_foot_data_row_number_topic_L"
#endif

/*******************************************************************/

#ifdef ROS_FOOT_MEASURE_MODE

Ticker ros_pub_ticker;

ros::NodeHandle  nh;
std_msgs::Int32MultiArray foot_msg;
ros::Publisher foot_pub(FOOT_PRESSURE_TOPIC, &foot_msg);

void init_ros()
{
    nh.initNode();
    nh.advertise(foot_pub);

    foot_msg.data_length = 14;
    foot_msg.data = (int *)malloc(sizeof(float)*14);
    for(int i = 0; i < foot_msg.data_length; i++) {
        foot_msg.data[i] = 0;
    }

    start_ros();
}

void start_ros()
{
    ros_pub_ticker.attach(&ros_pub_t,0.01);
}

void ros_pub_main()
{
    static int j=0;
    j++;
    if(j>100) {
        j=0;
    }

    foot_pub.publish(&foot_msg);

    for(int i=0; i<NUM_LINEAR+1; i++) {
        foot_msg.data[i] = (int)(sensor_foot[i].Getvalue_bio()*1000);
        foot_msg.data[NUM_LINEAR+i+1] = (int)(sensor_foot_device[i].Getvalue()*1000);
    }
    foot_msg.data[0] = j;
    foot_msg.data[4] = 0;
    foot_msg.data[6] = 0;
    foot_msg.data[NUM_LINEAR+1] = j;
    foot_msg.data[NUM_LINEAR+1+4] = 0;
    foot_msg.data[NUM_LINEAR+1+6] = 0;

    nh.spinOnce();

    wait_ms(0.01);

}

void ros_pub_t()
{
    ros_pub_main();
}

#endif

/******************************************************************/
#ifdef ROS_FOOT_REPEAT_MODE

Ticker ros_pub_ticker;

ros::NodeHandle  nh;
std_msgs::Int32MultiArray foot_msg;
std_msgs::Int32 row_number_msg;
ros::Publisher foot_pub(FOOT_PRESSURE_TOPIC, &foot_msg);
ros::Publisher row_number_foot_pub(ROS_FOOT_REPEAT_DATA_ROW_NUMBER_TOPIC, &row_number_msg);
ros::Subscriber<std_msgs::Int32MultiArray> repeat_foot_sub(ROS_FOOT_REPEAT_DATA_TOPIC, &Callback_foot);
ros::Subscriber<std_msgs::Int32MultiArray> foot_sub(ROS_FOOT_DATA_ROW_NUMBER_TOPIC, &Callback_foot_row_number);

DigitalOut myled(LED1);


int receive_row_number = 0;
int row_number = 0;
int row_num=0;
int **repeat_foot_data;
//int repeat_foot_target[1000][14]= {0};
int len_row_max=0;
bool len_row_max_flag=0;
int *temporary_data;

void Callback_foot(const std_msgs::Int32MultiArray& msg)
{
    receive_row_number = msg.data[0];
    /*
    for(int i=0; i<14; i++) {
        foot_msg.data[i] = msg.data[i];
        temporary_data[i] = msg.data[i];
    }*/
    temporary_data = msg.data;
    len_row_max = msg.data[7];
    if(len_row_max-1>receive_row_number) {
        if(receive_row_number==row_number) {
            for(int i=0; i<14; i++) {
                //(*repeat_foot_target)[row_number] = *temp_data;
                //(*repeat_foot_data)[row_number] = *temporary_data;
                repeat_foot_data[row_number][i] = temporary_data[i];
                //foot_msg.data[i] = repeat_foot_data[row_number][i];
                //repeat_foot_target[row_number][i] = temporary_data[i];
            }
            row_number++;
        }
    } else {
        len_row_max_flag = 1;
        //repeat_foot_sub.shutdown();
    }
    myled = !myled;
}

void fase_ros()
{
    receive_repeat_foot_data();
    //init_ros();
    //ros_publish_experiment_data();
}

void receive_repeat_foot_data()
{
    nh.initNode();
    nh.advertise(row_number_foot_pub);
    nh.subscribe(repeat_foot_sub);

    nh.advertise(foot_pub);
    nh.subscribe(foot_sub);

    //nh.advertise(foot_pub);
    foot_msg.data_length = 14;
    foot_msg.data = (int *)malloc(sizeof(float)*14);
    for(int i = 0; i < foot_msg.data_length; i++) {
        foot_msg.data[i] = 0;
    }

    repeat_foot_data = (int **)malloc(sizeof(int *) *1000);
    for(int i=0; i<1000; i++) {
        repeat_foot_data[i] = (int *)malloc(sizeof(int) *14);
    }

    for(int i=0; i<1000; i++) {
        for(int j=0; j<14; j++) {
            repeat_foot_data[i][j] = 0;
        }
    }

    row_number_msg.data = 0;

    wait(1);

    while(1) {
        //len_row_max>receive_row_number
        //row_number_msg.data ++;
        if(len_row_max_flag==1) {
            break;
        }
        row_number_msg.data = row_number;
        row_number_foot_pub.publish(&row_number_msg);
        //foot_pub.publish(&foot_msg);

        //foot_msg.data = temporary_data;//repeat_foot_data[row_number];
        //foot_msg.data = temp_data;//repeat_foot_data[row_number];
        /*
        for(int i=0; i<14; i++) {
            foot_msg.data[i] = repeat_foot_target[row_number][i];
        }*/
        /*
                for(int i=0; i<14; i++) {
                    foot_msg.data[i] = repeat_foot_data[row_number][i];
                }
        */
        /*
        for(int i=0; i++; i<14) {
            foot_msg.data[i] = *(repeat_foot_data+(row_number*14)+i);
        }*/
        //foot_pub.publish(&foot_msg);
        nh.spinOnce();
        wait(0.01);
    }

    ros_pub_t();
}

void Callback_foot_row_number(const std_msgs::Int32MultiArray& msg)
{
    row_num = msg.data[0];
}

void ros_pub_main()
{
    if(control_flag==0) {
        if(row_num<len_row_max) {
            foot_msg.data = repeat_foot_data[row_num];
        } else {
            //j=0;
        }
    } else if(control_flag==1) {
        for(int i=0; i<NUM_LINEAR; i++) {
            foot_msg.data[i] = 0;
        }
        foot_msg.data[0] = -1;
        foot_msg.data[7] = len_row_max;
    }

    foot_pub.publish(&foot_msg);

    nh.spinOnce();

    wait_ms(0.01);
}

void ros_pub_t()
{
    //start_ros();
    ros_pub_ticker.attach(&ros_pub_main,0.1);
}

#endif


/*******************************************************************/

#ifdef ROS_FOOT_EXPERIMENT_MODE

Ticker ros_pub_ticker;

ros::NodeHandle  nh;
std_msgs::Int32MultiArray foot_msg;
ros::Publisher foot_pub("foot_pressure_topic", &foot_msg);

void init_ros()
{
    nh.initNode();
    nh.advertise(foot_pub);

    foot_msg.data_length = 14;
    foot_msg.data = (int *)malloc(sizeof(float)*14);
    for(int i = 0; i < foot_msg.data_length; i++) {
        foot_msg.data[i] = 0;
    }

    start_ros();
}

void start_ros()
{
    ros_pub_ticker.attach(&ros_pub_t,0.05);
}

void ros_pub_main()
{
    static int j=0;
    j++;
    if(j>100) {
        j=0;
    }

    foot_pub.publish(&foot_msg);

    for(int i=0; i<NUM_LINEAR+1; i++) {
        foot_msg.data[i] = (int)(sensor_foot[i].Getvalue_bio()*1000);
        foot_msg.data[NUM_LINEAR+i+1] = (int)(sensor_foot_device[i].Getvalue()*1000);
    }
    foot_msg.data[0] = j;
    foot_msg.data[4] = 0;
    foot_msg.data[6] = 0;
    foot_msg.data[NUM_LINEAR+1] = j;
    foot_msg.data[NUM_LINEAR+1+4] = 0;
    foot_msg.data[NUM_LINEAR+1+6] = 0;

    nh.spinOnce();

    wait_ms(0.001);

}

void ros_pub_t()
{
    ros_pub_main();
}

#endif