#include "motor.h"
#include "M3_CAN.h"
#include "init.h"

M3_CAN_mbed m3(D4, D10, 1000000);

void init_m3_titech()
{
    m3.write(0, RG_SOFT_SRV,RG_DEFAULT, 1);
    m3.write(0, RG_CYCLE,RG_COMMUNICATE, 500000);
    m3.write(0, RG_CYCLE,RG_INTERPOLATE, 100);
    m3.write(0, RG_STATE,RG_DEFAULT, 11);
}

void move_motors(int *output)
{
    for(int i=1; i<NUM_LINEAR+1; i++) {
        if(i==4 || i==6) {  //4番、6番の直動機構は使わない
            continue;
        }
        if(output[i]>MAX_MOTOR)output[i] = MAX_MOTOR;                         //limit値
        else if(output[i]<MIN_MOTOR)output[i] = MIN_MOTOR;
        m3.write(i, RG_REFERENCE,RG_POSITION, output[i]);
        wait(0.0005);               //CAN通信調整用 ＊これがないと全部うまく通信できない 原因は不明だが通信用プログラムのループが早過ぎて次のIDの分のデータまで上手くつながらないのかもしれない
    }
}

void move_motor(int output, int i)
{
    if(output>MAX_MOTOR)output = MAX_MOTOR;     //limit値
    else if(output<MIN_MOTOR)output = MIN_MOTOR;
    m3.write(i, RG_REFERENCE,RG_POSITION, output);
    //wait(0.00001);
}

int32_t read_enc(int i)
{
    int32_t receive[NUM_LINEAR+1];
    m3.read(i, RG_PREVIOUS_DIR, RG_POSITION, &receive[i]);
    return receive[i];
}