#include "mbed.h"
#include "measure.h"
#include "init.h"
#include "control.h"
#include "motor.h"
#include "param.h"
#include "sensor.h"

#define UP_DISTANCE 0.5f //mm
#define MEASURE_TIME 100 //回

void measure_foot()
{
    //printf("start measure skin-elastic!...\r\n");
    move_motors(0);
    wait(3);

    int output[NUM_LINEAR+1];
    float sum_elastic[NUM_LINEAR+1];
    int measure_time;
    while(measure_time>MEASURE_TIME) {
        for(int i=1; i<NUM_LINEAR+1; i++) {
            output[i]+=convert_angle_to_enc(convert_distance_to_angle(UP_DISTANCE));
            move_motor(output[i],i);
            sum_elastic[i] += (sensor_foot_device[i].Getstress()/sensor_foot_device[i].Getepsilon());
            //printf("%d,\t",output[i]);
            wait(0.1);
        }
        //printf("\r\n");
        measure_time++;
    }
    
    for(int i=1; i<NUM_LINEAR+1; i++) {
        sensor_foot_device[i].skin_elastic = average(sum_elastic[i], measure_time);
        //printf("%f,%f\t\r\n", sensor_foot_device[i].Getforce(),sensor_foot_device[i].skin_elastic );
    }
}

float average(float sum, int number)
{
    return (float)sum/number;
}