#include "mbed.h"
#include "control.h"
#include "sensor.h"
#include "motor.h"
#include "init.h"
#include "param.h"

float convert_enc_to_angle(int enc)
{
    return enc*2*PI/(4*ENC_RESOLUTION);
}

int convert_angle_to_enc(float angle)
{
    return angle*4*ENC_RESOLUTION/(2*PI);
}

float convert_angle_to_distance(float angle)
{
    return angle*BALL_SCREW_LEAD/(2*PI);
}

float convert_distance_to_angle(float distance)
{
    return distance*2*PI/BALL_SCREW_LEAD;
}


int control_foot(float position, float velocity, float force, int id)
{
    int output;
    int output_position;
    //static float old_position[NUM_LINEAR+1] = {0};
    //float dis_position = position - old_position[id];
    //static float integral_position[NUM_LINEAR+1] = {0};
    //integral_position[id] += position;
    //output_position = Kp_position*(position - sensor_foot_device[id].Getposition());// + Kd_position*dis_position + Ki_position*integral_position[id];
    //old_position[id] = position;
    position = 0;
    output_position = convert_distance_to_angle(position)*180/PI*100;
    
    /*
    int output_velocity;
    static float old_velocity[NUM_LINEAR+1] = {0};
    float dis_velocity = velocity - old_velocity[id];
    static float integral_velocity[NUM_LINEAR+1] = {0};
    integral_velocity[id] += velocity;
    output_velocity = 0;//Kp_velocity*velocity + Kd_velocity*dis_velocity + Ki_velocity*integral_velocity[id];
    old_velocity[id] = velocity;
    */
    
    static int output_force[NUM_LINEAR+1] = {0};
    static float old_force[NUM_LINEAR+1] = {0};
    float dis_force = force - old_force[id];
    static float integral_force[NUM_LINEAR+1] = {0};
    integral_force[id] += force;
    output_force[id] = Kp_force*force + Kd_force*dis_force + Ki_force*integral_force[id];
    output_force[id] += Ki_force*force;
    old_force[id] = force;
  
    //#define OFFSET_CONTROL_ON
    #ifdef OFFSET_CONTROL_ON
    output =  output_position + /*output_velocity + */output_force[id] + BASE_POSITION;
    #endif
    #ifndef OFFSET_CONTROL_ON
    output =  output_force[id] + BASE_POSITION;
    #endif
    //output =  output_position;
    
/*
    if(output>400000)output = 400000;                         //limit値
    else if(output<0)output = 0;
  */  
    return output;
}
