/*
*このソースプログラムが足裏の位置を特定するためのソースです．
*ただし，圧力センサの値のみで計測を行っており，足が動かないことが条件です．
*あくまでも皮膚弾性率の計測と大まかな足裏の位置の特定として使ってください．
*/
#include "mbed.h"
#include "control.h"
#include "sensor.h"
#include "motor.h"
#include "init.h"
#include "calibration.h"

#define MOVE_INTERVAL 100
#define MOVE_INTERVAL_MAX 1000
#define SENSE_TIME 100
#define SENSOR_THRESHOLD 0.01f

//DigitalIn button(PC_13);
void find_foot()
{
    //printf("start calibration!!\r\n");
    bool sense_flag;
    int time;

    int move_angle[7]= {0};
    int output[7]= {0};
    while(1) {
        for(int i=1; i<NUM_LINEAR+1; i++) {
            float value = sensor_foot_device[i].Getvalue();
            if(value > SENSOR_THRESHOLD*40) {
                output[i] -= move_angle[i];
                sense_flag = 1;
                //move_angle[i] = 0;
                move_angle[i] += MOVE_INTERVAL;
            } else if(value>SENSOR_THRESHOLD) {
                output[i] -= move_angle[i];
                sense_flag = 1;
                //move_angle[i] = 0;
                move_angle[i] -= MOVE_INTERVAL;
            } else if(value<SENSOR_THRESHOLD) {
                output[i] += move_angle[i];
                sense_flag = 0;
                move_angle[i] += MOVE_INTERVAL;
            } else {
                output[i] = move_angle[i];
                sense_flag = 0;
            }
            if(move_angle[i]>MOVE_INTERVAL_MAX) move_angle[i]=MOVE_INTERVAL_MAX;
            else if(move_angle[i]<0) move_angle[i]=0;

            //move_motor(output[i], i);
        }

        if(sense_flag==1) {
            time++;
            if(time>SENSE_TIME) {
                for(int i=1; i<NUM_LINEAR+1; i++) {
                    sensor_foot_device[i].Update_offset();
                }
                //printf("complete find_foot!\r\n");
                break;
            }
        } else {
            time=0;
        }

        for(int i=1; i<NUM_LINEAR+1; i++) {
            //printf("\t%d,", output[i]);
            //printf("\t%f, ",sensor_foot_device[i].Getvalue());
        }
        //printf("\r\n");
        move_motors(output);
    }//while
}


