#include "crc.h"

uint8_t crc8(const uint8_t *data, int len)
{
    unsigned int crc = 0;

    for (int j = len; j; j--, data++)
    {
        crc ^= (*data << 8);
        for (int i = 8; i; i--)
        {
            if (crc & 0x8000)
            {
                crc ^= (CRC8_GEN << 3);
            }
            crc <<= 1;
        }
    }

    return (uint8_t)(crc >> 8);
}