// command packet consists of following parts
// u4 sflag
// u8 command
// u8 length
// u8 payload[len]
// u8 checksum
// u4 eflag


#ifndef COMMAND_PACKET2_H_
#define COMMAND_PACKET2_H_

#include <stdint.h>

class CommandPacket2
{
// public types
public:
    typedef enum
    {
        CP_SFLAG = '<',
        CP_EFLAG = '>'
    } CPFlag_t;
    
// private properties
private:
    uint8_t _sflag;
    uint8_t _command;
    uint8_t _length;
    uint8_t _payload[256];
    uint8_t _checksum;
    uint8_t _eflag;
    
    bool _isVerified;
    
// private methods
private:
    uint8_t calculate_checksum();
    
// public methods
public:
    CommandPacket2();
    ~CommandPacket2();
    
    void setSFlag(uint8_t sflag=CP_SFLAG);
    void setCommand(uint8_t command);
    void setLength(uint8_t length);
    void setPayload(uint8_t idx, uint8_t payload);
    void setChecksum(uint8_t checksum);
    void setEFlag(uint8_t eflag=CP_EFLAG);
    
    uint8_t getSFlag();
    uint8_t getCommand();
    uint8_t getLength();
    uint8_t getPayload(uint8_t idx);
    uint8_t getEFlag();
    uint8_t getChecksum();
    
    
    
    bool verify();
    void generateChecksum();
    int serialize(uint8_t *buffer);
    
};

#endif