#include <stdio.h>
#include "mbed.h"
#include "sx1276-inAir.h"

#define STRING_LENGTH 30
#define SUPPLY_VOLTAGE 3.3

Serial      pc(USBTX, USBRX);  //Create a serial connection to the PC
AnalogIn    ain(PA_0);             //Configure pin PA0 as an analog input for the temperature sensor
//DigitalIn   din(PB_10);         //Configure pin PC2 as a digital input for the reed switch
InterruptIn door(PB_10);

float reading_float;
bool reading_bool;

//Return the temperature from the sensor, in degrees celsius
float getTemp() {
    float reading = ain.read();
    float output_voltage = reading * SUPPLY_VOLTAGE;
    return (output_voltage - 0.25) / 0.028;
}

//Return the door state. If True, the door is closed. If False, the door is open.
bool getDoorState() {
    return door.read();
}

//Code that executes on a rising edge
//For reasons unknown, this executes twice instead of once when the magnet connects
//i.e. there are two falling edges. Could implement debouncing, but that takes effort
void transmitDoorClosing() {
    printf("The door has been closed\r\n");
}

//Code that executes on a falling edge
void transmitDoorOpening() {
    printf("The door has been opened\r\n");
}


int main() {

    //Configure the serial connection (baud rate = 19200, 8 data bits, 1 stop bit)
    pc.baud(9600);
    pc.format(8, SerialBase::None, 1);
    
    door.rise(transmitDoorClosing); //Rising edge occurs when the "door opens"
    door.fall(transmitDoorOpening); //Falling edge occurs when the "door closes"

    while(1) {

        char reading_string[STRING_LENGTH];
        reading_float = getTemp();
        sprintf(reading_string, " Temp: %.8f\r\n", reading_float);
        pc.printf("Temperature = %s\r\n", reading_string);

        wait_ms(500);

    }
}
