#ifndef BASICPACKET_H_
#define BASICPACKET_H_

#include <stdint.h>

class BasicPacket
{
private:
    // keep those private!
    // inherit class should always use public method to access those private
    // property
    uint8_t _buffer[8];

    // verify() function will toggle this variable
    // any other modification to internal properties
    // will revert this variable to false
    bool _isVerified;
    
public:
    typedef enum
    {
        L3ControlPacket = 0x0,
        L3DataBlockPacket,
    } L3Fid_t;

public:
    BasicPacket();
    BasicPacket(uint8_t *data);
    ~BasicPacket();

public:
    // calculate CRC value and write it into CRC field
    void generateCrc();

    // calculate CRC value and compare it with that in CRC field
    bool verify();

    // make a copy of internal buffer
    // the user 
    void serialize(uint8_t *buffer);

public:
    void setFid(uint8_t fid);
    void setSequenceID(uint8_t seqid);
    void setSourceID(uint8_t sid);
    void setDestinationID(uint8_t did);
    void setField(uint8_t idx, uint8_t data);

    uint8_t getFid();
    uint8_t getSequenceID();
    uint8_t getSourceID();
    uint8_t getDestinationID();
    uint8_t getField(uint8_t idx);
    uint8_t getCrc();

#ifdef _DEBUG
public:
    void unit_test();
#endif
};

#endif