#include "DataBlockPacket.h"

#ifdef _DEBUG
#include <cassert>
#endif

DataBlockPacket::DataBlockPacket()
{
    setFid(0x1);
}

DataBlockPacket::DataBlockPacket(uint8_t *data)
    : BasicPacket(data)
{
    setFid(0x1);
}

DataBlockPacket::~DataBlockPacket()
{
}

void DataBlockPacket::setSourceType(uint8_t type)
{
    uint8_t block = getField(0);
    
    // clear upper 4 bits
    block &= 0x0f;
    
    // set bits
    block |= type << 4;
    
    // write back
    setField(0, block);
}

void DataBlockPacket::setPayloadType(uint8_t bid)
{
    uint8_t block = getField(0);
    
    // clear lower 4 bits
    block &= 0xf0;
    
    // set bits
    block |= bid & 0x0f;
    
    // write back
    setField(0, block);
}

void DataBlockPacket::setData(uint8_t idx, uint8_t data)
{
    setField(idx + 1, data);
}

uint8_t DataBlockPacket::getSourceType()
{
    return (getField(0) & 0xf0) >> 4;
}

uint8_t DataBlockPacket::getPayloadType()
{
    return getField(0) & 0x0f;   
}

uint8_t DataBlockPacket::getData(uint8_t idx)
{
    return getField(idx + 1);
}

#ifdef _DEBUG
void DataBlockPacket::unit_test()
{
    // value test
    DataBlockPacket testObject;
    
    testObject.setBlockID(0x1);
    testObject.setDataBlock0(0xee);
    testObject.setDataBlock1(0xff);

    assert(0x1 == testObject.getBlockID());
    assert(0xee == testObject.getDataBlock0());
    assert(0xff == testObject.getDataBlock1());

    assert(false == testObject.verify());
    testObject.generateCrc();
    assert(true == testObject.verify());
    assert(0x4e == testObject.getCrc());

    // value test 2
    uint8_t testString[] = { 0x21, 0xee, 0xff, 0x4e };
    DataBlockPacket testObject2(testString);
    
    assert(0x1 == testObject2.getBlockID());
    assert(0xee == testObject2.getDataBlock0());
    assert(0xff == testObject2.getDataBlock1());

    assert(true == testObject2.verify());
    testObject2.generateCrc();
    assert(true == testObject2.verify());
    assert(0x4e == testObject2.getCrc());
}
#endif