#include "ControlPacket.h"

#ifdef _DEBUG
#include <cassert>
#endif

ControlPacket::ControlPacket()
    : BasicPacket()
{
    setFid(0x0);
}

ControlPacket::ControlPacket(uint8_t *data)
    : BasicPacket(data)
{
    setFid(0x0);
}

ControlPacket::~ControlPacket()
{
}

void ControlPacket::setCommand(uint8_t cmd)
{
    setField(0, cmd);
}

void ControlPacket::setData(uint8_t idx, uint8_t data)
{
    setField(idx + 1, data);   
}

uint8_t ControlPacket::getCommand()
{
    return getField(0);
}

uint8_t ControlPacket::getData(uint8_t idx)
{
    return getField(idx + 1);
}

#ifdef _DEBUG
void ControlPacket::unit_test()
{
    // value test
    ControlPacket testObject;

    testObject.setSequenceID(0x1);
    testObject.setSourceID(0x2);
    testObject.setDestinationID(0x3);
    testObject.setCommand(0x4);
    
    assert(0x0 == testObject.getFid());
    assert(0x1 == testObject.getSequenceID());
    assert(0x2 == testObject.getSourceID());
    assert(0x3 == testObject.getDestinationID());
    assert(0x4 == testObject.getCommand());

    assert(false == testObject.verify());
    testObject.generateCrc();
    assert(0x3d == testObject.getCrc());

    // value test 2
    uint8_t testString[] = { 0x01, 0x23, 0x40, 0x3d };
    ControlPacket testObject2(testString);

    assert(0x0 == testObject2.getFid());
    assert(0x1 == testObject2.getSequenceID());
    assert(0x2 == testObject2.getSourceID());
    assert(0x3 == testObject2.getDestinationID());
    assert(0x4 == testObject2.getCommand());

    assert(true == testObject2.verify());
    testObject2.generateCrc();
    assert(0x3d == testObject2.getCrc());
}
#endif