#ifndef ALOHAFRAME_H_
#define ALOHAFRAME_H_

#include <stdint.h>

#define MAX_FRAME_SZ 20
#define MAX_PAYLOAD_SZ 16
#define FIXED_BYTE MAX_FRAME_SZ - MAX_PAYLOAD_SZ
#define ALOHA_MAX_TYPE 16

class AlohaFrame
{
private:
    uint8_t _buffer[MAX_FRAME_SZ];

    bool _isVerified;
    
public:
    typedef enum 
    {
        Aloha_Join_Request = 0x0,
        Aloha_Join_Accepted,
        Aloha_Join_Denied,
        Aloha_Authentication,
        Aloha_Deauthentication,
        Aloha_RTS,
        Aloha_CTS,
        Aloha_Data,
        Aloha_ACK,
        Aloha_NACK,
    } AlohaType_t;

public:
    AlohaFrame();
    AlohaFrame(uint8_t *data, uint8_t sz=MAX_PAYLOAD_SZ);
    ~AlohaFrame();

public:
    void generateCrc();

    bool verify();

    uint8_t serialize(uint8_t *buffer);

public:
    void setType(uint8_t type);
    void setPayloadLength(uint8_t length);
    void setSourceAddress(uint8_t sa);
    void setDestinationAddress(uint8_t da);
    void setFullMessageFlag(uint8_t fmf);
    void setSequenceID(uint8_t seqid);
    void setPayload(uint8_t idx, uint8_t payload);

    uint8_t getType();
    uint8_t getPayloadLength();
    uint8_t getSourceAddress();
    uint8_t getDestinationAddress();
    uint8_t getFullMessageFlag();
    uint8_t getSequenceID();
    uint8_t getPayload(uint8_t idx);
    uint8_t getCrc();

#ifdef _DEBUG
public:
    void unit_test();
#endif
};

#endif
