#include "LSM9DS1.h"
#include "mbed.h"
#include "aconno_i2c.h"

LSM9DS1::LSM9DS1(I2C *i2c_, char address) : i2c(i2c_, address){
}

/*uint8_t LSM9DS1::whoIAm(){
    char regAddr = (char)WHO_AM_I;
    char regData;
    i2c.readFromReg(regAddr, &regData, 1);
    return (uint8_t)regData;
}
*/
uint8_t LSM9DS1::setMode(Mode mode){
    char ctrl1Copy;
    char ctrl4Copy;
    uint8_t success;
    
    //i2c.readFromReg((char)CTRL_REG1, &ctrl1Copy, 1); 
    //i2c.readFromReg((char)CTRL_REG4, &ctrl4Copy, 1);
    
/* DONT NEED TO SWITCH MODE CAUSE JUST USING ACCELERATION

    switch(mode){
        case HIGH_RES:
            ctrl1Copy &= 0xF7;
            ctrl4Copy |= 0x08;
            break;
        case NORMAL:
            ctrl1Copy &= 0xF7;
            ctrl4Copy &= 0xF7;
            break;
        case LOW_POWER:
            ctrl1Copy |= 0x08;
            ctrl4Copy &= 0xF7;
            break;
        default:
            return 0;
    }
    i2c.writeToReg((char)CTRL_REG5_XL, &ctrl1Copy, 1);
    success = i2c.writeToReg((char)CTRL_REG6_XL, &ctrl4Copy, 1);
    return success;
}

*/

uint8_t LSM9DS1::enableAxes(Axis axis){
    char ctrl1Copy;
    i2c.readFromReg((char)CTRL_REG5_XL, &ctrl1Copy, 1);
    ctrl1Copy |= axis;
    i2c.writeToReg((char)CTRL_REG6_XL, &ctrl1Copy, 1);
    return 0;
}

uint8_t LSM9DS1::disableAxes(Axis axis){
    char ctrl1Copy;
    i2c.readFromReg((char)CTRL_REG5_XL, &ctrl1Copy, 1);
    ctrl1Copy &= ~(1 << axis);
    i2c.writeToReg((char)CTRL_REG6_XL, &ctrl1Copy, 1);
    return 0;
}

int16_t LSM9DS1::readXAxis(){
    int16_t rawData;
    char tempData;
    // Make sure new data is ready
    do{
        i2c.readFromReg((char)STATUS_REG_0, &tempData, 1);
    }while(!(tempData & 0x08));
    do{
        i2c.readFromReg((char)STATUS_REG_0, &tempData, 1);
    }while(!(tempData & 0x80));
    // Same data have been overwritten
    
    i2c.readFromReg((char)OUT_X_H_XL, &tempData, 1);
    rawData = (int8_t)tempData << 8;
    i2c.readFromReg((char)OUT_X_L_XL, &tempData, 1);
    rawData |= (int8_t)tempData;
    return rawData;
}

int16_t LSM9DS1::readYAxis(){
    int16_t rawData;
    char tempData;
    i2c.readFromReg((char)OUT_Y_H_XL, &tempData, 1);
    rawData = (int8_t)tempData << 8;
    i2c.readFromReg((char)OUT_Y_L_XL, &tempData, 1);
    rawData |= (int8_t)tempData;
    return rawData;
}

int16_t LSM9DS1::readZAxis(){
    int16_t rawData;
    char tempData;
    i2c.readFromReg((char)OUT_Z_H_XL, &tempData, 1);
    rawData = (int8_t)tempData << 8;
    i2c.readFromReg((char)OUT_Z_L_XL, &tempData, 1);
    rawData |= (int8_t)tempData;
    return rawData;
}

//uint8_t LSM9DS1::setODR(Odr odr){
  //  char ctrl1Copy;
    //i2c.readFromReg((char)CTRL_REG8, &ctrl1Copy, 1);
    //ctrl1Copy |= (odr << 4);
    //i2c.writeToReg((char)CTRL_REG8, &ctrl1Copy, 1);
    //return 0;
//}

/*uint8_t LSM9DS1::setScale(Scale scale){
    char ctrl4Copy;
    i2c.readFromReg((char)CTRL_REG9, &ctrl4Copy, 1);
    ctrl4Copy |= (scale << 4);
    i2c.writeToReg((char)CTRL_REG9, &ctrl4Copy, 1);
    return 0;
}
*?

/* Interrupt activity 1 driven to INT1 pad */

/*
uint8_t LSM9DS1::int1Setup(uint8_t setup){
    char data = setup;
    i2c.writeToReg((char)CTRL_REG6_XL, &data, 1);
    return 0;
}


*/


/*uint8_t LSM9DS1::int1Latch(uint8_t enable){
    char ctrl5Copy;
    i2c.readFromReg((char)CTRL_REG5, &ctrl5Copy, 1); //reg for magnetometer
    ctrl5Copy |= enable;
    i2c.writeToReg((char)CTRL_REG5, &ctrl5Copy, 1);
    return 0; 
}
*/

/*uint8_t LSM9DS1::int1Duration(uint8_t duration){
    char copy = duration;
    i2c.writeToReg((char)INT1_DURATION, &copy, 1);//reg for magnetometer
    return 0;
}
*/


/*
uint8_t LSM9DS1::int1Threshold(uint8_t threshold){
    char copy = threshold;
    i2c.writeToReg((char)INT1_THS, &copy, 1);
    return 0;
}

uint8_t LSM9DS1::int1Config(uint8_t config){
    char copy = config;
    i2c.writeToReg((char)INT1_CFG, &copy, 1);
    return 0;
}

void LSM9DS1::clearIntFlag(){
    char data;
    i2c.readFromReg((char)INT1_SRC, (char*)&data, 1);
}

*/
 