//plan of debugging and what the result was
//what the problem is and how :lessons learned what was tried
//your own development and knowledge
//analysis report - working hard thinking throug the problems
//less is more - essential information
//what your thinkijg is what problems are and what u tried
//point form 


 /* Copyright (c) 2016 Aconno. All Rights Reserved.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */


#include "mbed.h"
#include "acd52832_bsp.h"
//#include "LSM9DS1_regs.h"
//#include "LSM9DS1_defVals.h"
#include "LSM9DS1.h"
#include "GDEP015OC1.h"
#include "aconno_i2c.h"
//#include "main.h"

// #define GYRO

SPI spi(p3, NC, p4); //keep this spi connection - for e paper display 
GDEP015OC1 epd = GDEP015OC1(spi, p5, p6, p7, p8);

// Initialize I2C protocol
I2C mems(PIN_EXP_SDA, PIN_EXP_SCL);
char memsI2CAddress = I2C_ADDRESS;
LSM9DS1 mems(&i2c, memsI2CAddress);


DigitalOut RED(PIN_LED_RED);
DigitalOut GREEN(PIN_LED_GREEN);
DigitalOut BLUE(PIN_LED_BLUE);
DigitalOut LEDD(PIN_LED);


uint8_t LSM9DS1::enableAxes(Axis axis){
    char ctrl1Copy;
    i2c.readFromReg((char)CTRL_REG5_XL, &ctrl1Copy, 1);
    ctrl1Copy |= axis;
    i2c.writeToReg((char)CTRL_REG6_XL, &ctrl1Copy, 1);
    return 0;
}

int16_t LSM9DS1::readXAxis(){
    int16_t rawData;
    char tempData;
    // Make sure new data is ready
    do{
        i2c.readFromReg((char)STATUS_REG_0, &tempData, 1);
    }while(!(tempData & 0x08));
    do{
        i2c.readFromReg((char)STATUS_REG_0, &tempData, 1);
    }while(!(tempData & 0x80));
    // Same data have been overwritten
    
    i2c.readFromReg((char)OUT_X_H_XL, &tempData, 1);
    rawData = (int8_t)tempData << 8;
    i2c.readFromReg((char)OUT_X_L_XL, &tempData, 1);
    rawData |= (int8_t)tempData;
    return rawData;
}

int16_t LSM9DS1::readYAxis(){
    int16_t rawData;
    char tempData;
    i2c.readFromReg((char)OUT_Y_H_XL, &tempData, 1);
    rawData = (int8_t)tempData << 8;
    i2c.readFromReg((char)OUT_Y_L_XL, &tempData, 1);
    rawData |= (int8_t)tempData;
    return rawData;
}

int16_t LSM9DS1::readZAxis(){
    int16_t rawData;
    char tempData;
    i2c.readFromReg((char)OUT_Z_H_XL, &tempData, 1);
    rawData = (int8_t)tempData << 8;
    i2c.readFromReg((char)OUT_Z_L_XL, &tempData, 1);
    rawData |= (int8_t)tempData;
    return rawData;
}




void check(bool success)
{
    if(!success) {
        // serial.printf("Success.\n");
        RED = 1;
        GREEN = 0;
    } else {
        // serial.printf("Unsuccess!\n");
        RED = 0;
        GREEN = 1;
        wait(2);
    }
    wait (0.05);
    RED = 1;
    GREEN = 1;
}







void start_acc()
{
    char data[2];
    bool success;
    
    data[0] = (char)CTRL_REG5_XL;          // Target register
    data[1] = (char)0x38;                 // Data to write
    success = mems.write(TWI_AG_ADDR, data, 0x02,0);
    check(success);
    
    data[0] = (char)CTRL_REG6_XL;          // Target register
    data[1] = (char)0xC7;                 // Data to write
    success = mems.write(TWI_AG_ADDR, data, 0x02,0);
    check(success);
    
}

void read_acc(float *results){
    char results_[6];
    float res_final[3];
    char out_x_l_xl = OUT_X_L_XL;
    
    check (mems.write(TWI_AG_ADDR, &out_x_l_xl, 1, true));
    check (mems.read(TWI_AG_ADDR, results_, 6, 0));
    res_final[0] = ((results_[1]<<8) | results_[0]);
    res_final[1] = ((results_[3]<<8) | results_[2]);
    res_final[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = res_final[0];
    *(results + 1) = res_final[1];
    *(results + 2) = res_final[2];
}

//////////////////////////////////////////////////////
void read_bb(float *res) {
    char res_[6];
    float final_res[3];
    char out_bb = out_xl_bb;
}//char out_xl_bb
/////////////////////////////////////////////////////////

int main()
{
    float old_res = 0;
    float results[3];
    char buffer[6];

    // Clear LEDs
    RED = 1;
    GREEN = 1;
    //-----------------
    
    
    
    // Start acceleration sensor
    start_acc();

    while (1) {        
        // Get data from ag sensor
        
        read_acc(results);
        
        if (*results != old_res) {
            // Write new value on display
            epd.empty();
            ////////////////////
            epd.writeString("Aconno Accelerometer Data:",10,50,0);
            //////////////////
            epd.write();
            
            
            
            // Write ag_x
            sprintf(buffer, "%+2.1f", *results);    //Create a string
            epd.writeString(buffer,85,70,0);                                       //Write new data to the buffer
            epd.write();
            
            // Write ag_y
            sprintf(buffer, "%+2.1f", *(results+1));    //Create a string
            epd.writeString(buffer,85,80,0);                                       //Write new data to the buffer
            epd.write();
            
            // Write ag_z
            sprintf(buffer, "%+2.1f", *(results+2));    //Create a string
            epd.writeString(buffer,85,90,0);                                       //Write new data to the buffer
            epd.write();

            old_res = *results;
            BLUE = 0;
            wait (1);
            BLUE = 1;
            wait(1);
            
            
        
        }
        LEDD = 0;
        wait(1);
        LEDD = 1;
        wait(1);
    }

// from the bb:
//while(1){
  
  //the functions are in the wrong class
enableI2C();
        mems.enableAxes(X_axis);    ////enable axis not woking????
        mems.readXaxis();
        mems.disableAxes(X_axis);
        mems.enableAxes(Y_axis); 
        mems.readYaxis();
        mems.disableAxes(Y_axis);
        mems.enableAxes(Z_axis); 
        mems.readZaxis();
        mems.disableAxes(Z_axis);
        epd.writeString("BB Accelerometer Data:",10,90,0);
        epd.write();
        ///////////// write to epd
        ///add in epd for each

 
//}