/*
Namen: Lennart Groen
Klas: EMT1PSa
Opdracht: MBED - Stoplicht
Samengewerkt met: ...
Datum: 17-03-2018
Inspiratie uit: https://os.mbed.com/users/4180_1/notebook/rgb-leds/
*/

#include <mbed.h>
DigitalIn ring_NZ = D4;
DigitalIn ring_OW = D2;

struct lichtkleur {             // Struct voor beheren LED kleuren van stoplicht
    float val_rood, val_groen, val_blauw;
};

enum State {                    // State machine status
    STATE_ROOD,
    STATE_NZ_GROEN,
    STATE_NZ_ORANJE,
    STATE_OW_GROEN,
    STATE_OW_ORANJE,
    STATE_RING_NZ,
    STATE_RING_OW,
};

// Defineren van ledkleuren voor RGB LED - Buiten class omdat dit compiling errors geeft
const lichtkleur rood = { 0.0,1.0,1.0};
const lichtkleur geel = { 0.5,0.0,1.0};
const lichtkleur groen = { 1.0,0.0,1.0};


class stoplicht                 // Class voor object stoplicht
{
public:
    stoplicht(PinName p_rood, PinName p_groen, PinName p_blauw);
    void set_rood();
    void set_geel();
    void set_groen();
private:
    PwmOut pin_rood;
    PwmOut pin_groen;
    PwmOut pin_blauw;
};

int main()
{
    enum State stoplicht_state = STATE_ROOD;    // State machine status wegschrijven

    stoplicht stoplicht_nz(D11, D10, D9);       // defineren stoplicht noord zuid (pin_rood, pin_groen, pin_blauw)
    stoplicht stoplicht_ow(D6, D5, D3);         // defineren stoplicht oost west  (pin_rood, pin_groen, pin_blauw)
    enum State prev_state = STATE_OW_ORANJE;    // bijhouden van vorige state om te bepalen welke stoplicht aan gaat na rood

    Timer timer1;                               // timer voor beheren van tijd interrupt
    timer1.start();

    while(1) {


        switch (stoplicht_state) {
            case STATE_ROOD:
                stoplicht_nz.set_rood();
                stoplicht_ow.set_rood();
                if(prev_state == STATE_OW_ORANJE && timer1.read() >= 1) {
                    stoplicht_state = STATE_NZ_GROEN;
                    timer1.reset();
                } else if(prev_state == STATE_NZ_ORANJE && timer1.read() >= 1) {
                    stoplicht_state = STATE_OW_GROEN;
                    timer1.reset();
                }
                break;
            case STATE_NZ_GROEN:
                stoplicht_nz.set_groen();
                if(timer1.read() >= 19) {
                    stoplicht_state = STATE_NZ_ORANJE;
                    timer1.reset();
                }
                break;
            case STATE_NZ_ORANJE:
                stoplicht_nz.set_geel();
                if(timer1.read() >= 1) {
                    prev_state = STATE_NZ_ORANJE;
                    stoplicht_state = STATE_ROOD;
                    timer1.reset();
                }
                break;
            case STATE_OW_GROEN:
                stoplicht_ow.set_groen();
                if(timer1.read() >= 19) {
                    stoplicht_state = STATE_OW_ORANJE;
                    timer1.reset();
                }
                break;
            case STATE_OW_ORANJE:
                stoplicht_ow.set_geel();
                if(timer1.read() >= 1) {
                    prev_state = STATE_OW_ORANJE;
                    stoplicht_state = STATE_ROOD;
                    timer1.reset();
                }
                break;
             case STATE_RING_NZ:
          
                if(timer1.read() >= 3) {
                    stoplicht_state = STATE_OW_ORANJE;
                    timer1.reset();
                }
                case STATE_RING_OW:
         
                if(timer1.read() >= 3) {
                    stoplicht_state = STATE_NZ_ORANJE;
                    timer1.reset();
                }
                break;
            default:
                stoplicht_state = STATE_ROOD;
                break;
        }
        if (ring_NZ == 1 && stoplicht_state == STATE_OW_GROEN) {
               timer1.reset();
            stoplicht_state = STATE_RING_NZ;
        }
        if (ring_OW == 1 && stoplicht_state == STATE_NZ_GROEN){
               timer1.reset();
            stoplicht_state = STATE_RING_OW;
        }

    }

}

stoplicht::stoplicht(PinName p_rood, PinName p_groen, PinName p_blauw)
    :pin_rood(p_rood), pin_groen(p_groen), pin_blauw(p_blauw)
{

}

// Functies voor stoplicht class //
void stoplicht::set_groen()
{
    pin_rood = groen.val_rood;
    pin_groen = groen.val_groen;
    pin_blauw = groen.val_blauw;
}


void stoplicht::set_geel()
{
    pin_rood = geel.val_rood;
    pin_groen = geel.val_groen;
    pin_blauw = geel.val_blauw;
}


void stoplicht::set_rood()
{
    pin_rood = rood.val_rood;
    pin_groen = rood.val_groen;
    pin_blauw = rood.val_blauw;
}

