/*
Namen: Lennart Groen
Klas: EMT1PSa
Opdracht: MBED - Stoplicht
Samengewerkt met: ...
Datum: 17-03-2018
Inspiratie uit: https://os.mbed.com/users/4180_1/notebook/rgb-leds/
*/

#include <mbed.h>

struct lichtkleur{              // Structure for 
    float rood, groen, blauw;
};

// Programmed outside class because mbed won't accept it
const lichtkleur rood = { 0.0,1.0,1.0};
const lichtkleur geel = { 0.5,0.0,1.0};
const lichtkleur groen = { 1.0,0.0,1.0};


class stoplicht{
 public:
    stoplicht(PinName p_rood, PinName p_groen, PinName p_blauw);
    void set_rood();
    void set_geel();
    void set_groen();    
 private:
 PwmOut pin_rood;
 PwmOut pin_groen;
 PwmOut pin_blauw;
};

int main()
{
    stoplicht stoplicht_nz(D11, D10, D9);
    stoplicht stoplicht_ow(D6, D5, D3);
    Timer timer1;
    timer1.start();
    int state = 0;
    
while(1){

    switch(state){
        case 0:
            stoplicht_nz.set_groen();
            break;
        case 1:
            stoplicht_ow.set_groen();
            break;
    }
            
        
    if(timer1.read() > 5){
       switch(state){
        case 0:
            stoplicht_nz.set_rood();
            wait(1);
            state = 1;
            break;
        case 1:
            stoplicht_ow.set_rood();
            wait(1);
            state = 0;
            break;
        }
        timer1.reset();
     }
    }
}

stoplicht::stoplicht(PinName p_rood, PinName p_groen, PinName p_blauw)
    :pin_rood(p_rood), pin_groen(p_groen), pin_blauw(p_blauw)
{
        
}

// Functies voor stoplicht class //
void stoplicht::set_groen()
{
        pin_rood = groen.rood;
        pin_groen = groen.groen;
        pin_blauw = groen.blauw;
}


void stoplicht::set_geel()
{
        pin_rood = geel.rood;
        pin_groen = geel.groen;
        pin_blauw = geel.blauw;
}


void stoplicht::set_rood()
{
        pin_rood = geel.rood;
        pin_groen = geel.groen;
        pin_blauw = geel.blauw;
        wait(1);
        pin_rood = rood.rood;
        pin_groen = rood.groen;
        pin_blauw = rood.blauw;
}

