#ifndef ENCODER_H
#define ENCODER_H

#include "mbed.h"


class Encoder{
    Timer t;
    
    //Intervals used during encoder data collection to measure velocity
    int interval1;
    int interval2;
    int interval3;
    int avg_interval;
    int lastchange1;
    int lastchange2;
    int lastchange3;
    int lastchange4;
    
    //Variables used to for velocity control
    float avg_speed;
    float stall_check;
    float tuning_val;
    
    // Servo parameters
    float lastTurnTime;
    bool servoLeft;
    
    //Parameters specifying sample sizes and delays for small and large average speed samples
    float num_samples_small;
    float delay_small;
    float num_samples_large;
    float delay_large;
    
    // Large and small arrays used to get average velocity values
    float large_avg_speed_list [100];
    float small_avg_speed_list [10];
public:
    Encoder(Timer t);
    float velocity_control(float duty_cyc, float tuning_const);
    void fallInterrupt();
    void riseInterrupt();
private:
    // Internal functions
    float get_speed();
    float get_avg_speed(float num_samples, float delay);
};


#endif