/* 
Copyright 2014 ELZET80 Mikrocomputer GmbH&Co., KG

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*---------------------------------------------------------------------------*
 * mbed RAIL24V demo application
 *---------------------------------------------------------------------------*
 * Description:
 *      This program should demonstrate some features of the mbed RAIL24V Board
 *      and help to write own web applications for the LPC1768 mbed board.
 *      
 *      Features:
 *          * Webserver listening on port 80 with io port handling
 *          * RS232/RS485 echo
 *          * examples for interrupt and thread handling
 *
 *      Debugging:
 *          * via "embedded" mbed USB->Serial Port (9600 Baud)
 *---------------------------------------------------------------------------*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPD.h"


#define debug               //enable debug output on virtual usb->com port
#define dhcp_disable        //use user defined ip-address

/*----------------------------------------------------------------------------
 *      constants
 *---------------------------------------------------------------------------*/

/*content and length of "/dynamic/Elogo.gif"*/
const char* const elogo_gif = "\x47\x49\x46\x38\x39\x61\x5D\x00\x70\x00\xC4\x00\x00\x88\xCB\xBB\x47\x7B\xB8\xC3\xE5\xDD\xC1\xD3\xE7\x4D\xB1\x99\x85\xA8\xD0\x19\x5A\xA6\xE0\xE9\xF3\xC2\xD4\xE8\x75\x9C\xCA\x65\x91\xC4\x28\x65\xAC\x93\xB2\xD5\x37\x70\xB2\xEF\xF4\xF9\xA3\xBD\xDB\xB2\xC8\xE1\xC4\xE6\xDD\xD1\xDE\xED\x89\xCC\xBB\x56\x86\xBE\xE1\xF2\xEE\xF0\xF9\xF7\xA6\xD8\xCC\xD2\xEB\xE5\xE2\xF2\xEE\xC4\xE5\xDD\xA3\xBD\xDC\x84\xA7\xD0\x12\x98\x77\x0A\x50\xA1\xFF\xFF\xFF\x21\xF9\x04\x00\x00\x00\x00\x00\x2C\x00\x00\x00\x00\x5D\x00\x70\x00\x00\x05\xFF\x60\xE1\x8D\x64\x69\x9E\x68\xAA\xAE\x6C\xEB\x7A\xE2\x2B\xCF\x74\xCD\xC6\x76\xAE\xEF\x29\xCE\xFF\x40\x9A\x2F\x48\x2C\xA2\x86\x8B\x80\x72\xC9\x4C\x25\x03\x8B\x56\x83\x49\x6D\xA0\xA8\x54\xC3\xC9\x80\x65\x6A\x4B\x43\xCE\x67\x4C\x2E\xA7\xC4\x1F\x4E\x6B\x50\x6E\x0F\x50\xED\x76\xE0\x94\x88\x97\xE7\x60\x13\xDA\xFE\x39\x8F\xD5\x2C\x6C\x7C\x6F\x27\x7C\x63\x78\x25\x7B\x76\x88\x23\x61\x63\x07\x1C\x91\x92\x80\x27\x68\x94\x2A\x0A\x93\x91\x07\x63\x0F\x70\x7F\x9A\x1C\x51\x26\x01\x92\x0F\x8F\x92\xA3\x24\x8E\x1F\x84\x2E\x96\x36\x0E\x63\x14\x9F\x7D\x34\x01\x63\xAE\x27\xAC\xBA\x2C\xB0\x34\x14\x63\x0E\x29\x64\x35\xB8\xAD\x2A\xBC\x32\xBF\x33\xA7\x1F\x9E\xB5\xC6\xB9\xC9\x7A\xD3\x2F\xCC\x2F\x06\x64\xB4\xD1\xB7\xD6\x47\xD5\xC8\xD7\x7F\x34\x0A\x8F\x2A\xC5\xDE\xE2\xE0\x89\xDF\x2D\xD8\x2E\x10\x63\x0C\xE8\x63\xD2\xEB\xBB\xE1\xBD\x2B\xF0\x2C\xDA\x63\x56\x88\xD9\x53\xB7\x6F\x55\x38\x48\x9A\x54\x85\xBB\xD4\xC2\xDC\x87\x03\x2B\xC8\x84\x62\x74\xC5\x9D\x09\x56\x8B\xFC\xA4\x99\x21\xEF\x03\xBD\x7A\x76\x18\x9E\x38\x56\xB0\x51\xB8\x8C\x28\xFA\xFF\xA9\xF8\xF7\x21\xA0\xC0\x90\x2C\x48\x52\x6B\xF7\x41\x02\x96\x2F\x95\xC8\xBD\xA8\x53\x93\x05\x19\x2C\x0A\x2B\xE2\xBB\xA8\x6F\x99\x4E\x17\x12\xC6\x24\xF0\x39\x70\x86\xCC\x1E\x45\xC7\x6D\x74\xB1\x80\x4C\xD0\x42\x4D\x65\x3C\x65\x47\x02\x4D\xC9\x94\x47\x59\xF0\x94\xD0\x22\x9D\x53\x8B\x79\x68\x7E\xCD\x39\xB5\x45\xD2\x0F\x4B\x99\xDA\x3A\x3B\x34\x6D\x57\xB4\x2A\x54\x9E\xA8\x3A\x06\x27\xC8\x7B\x5F\x95\x49\x15\x09\xF6\x03\x04\x17\x66\xB5\xE2\x35\xA9\xD6\x68\xDB\x15\x9C\x3E\x28\x40\x9C\xF5\xC5\xD6\x7C\x8D\x07\x4B\x21\xE3\xF7\x2F\xC1\x99\x77\xEB\xE6\x0D\x9B\x82\xC1\x98\xC3\x94\xE7\x2A\x16\xCD\x38\x34\x1F\x8A\x23\x14\x95\xD9\x27\xC8\x4E\x41\x43\x8F\x47\x2E\x86\x71\x12\x65\xEF\xD9\x27\x6A\xC7\xB9\x6D\x88\x30\x89\xCB\x44\x69\xBE\x2E\x3C\x3C\xB8\x21\xE2\x7C\x8C\x8F\x40\x6E\xD7\x88\x75\xEB\x43\xAE\x6B\xFF\x91\x7D\xBB\x77\x1B\xDD\xBF\x8B\x7F\x11\x7E\x45\xA6\x50\xE8\xD3\xAB\x5F\xCF\x3E\x12\xF8\x1A\xC2\x71\xCB\x9F\x4F\xDF\x4C\x8D\xF2\x2A\xE2\xD7\xDF\xCF\xDF\xBE\x10\xF8\xFD\x05\x28\xE0\x7B\x34\xE8\x27\xE0\x81\x86\xD8\x30\x40\xFF\x7B\xA1\x44\x86\xE0\x83\xC5\x31\xA8\x09\x84\x14\x56\x68\xE1\x85\x0F\x25\x00\x45\x12\x09\x38\xC8\xC7\x01\x1A\x8E\xB0\x00\x05\xCE\x60\x68\x62\x1C\x71\xD1\x61\xC8\x03\x9D\x4D\x27\xCB\x89\x30\x4E\x86\x89\x1D\xD0\xA4\xD0\xC0\x8B\x30\x5E\xF8\x11\x3F\x6D\x38\xD0\xA2\x09\x3C\xE5\x58\xA1\x8F\x2D\x18\x80\x23\x5C\x2E\x78\x58\xE1\x05\x04\x34\xE9\xE4\x93\x50\x3A\x89\x81\x21\x3B\x92\xD0\x80\x4B\x24\x98\xC6\xD9\x2B\xB8\x45\xE9\x65\x94\x13\x74\x20\xE6\x98\x64\x96\x39\xA6\x00\x86\x50\xA4\x65\x8D\xD3\x91\x81\x1A\x09\x06\x0C\xE0\x80\x8C\x24\xF0\xC5\x87\x99\x78\x9A\x19\x66\x9E\x7C\xA2\xC9\x87\x09\x76\xB6\x64\x02\x19\x29\xC6\x26\x4C\x67\x4A\x96\xC1\xE7\xA2\x4C\x7E\xE9\xE8\x94\x76\x0C\x53\x42\x90\xB9\x45\x86\xA5\x07\x0E\xD2\x39\x42\x89\x71\x38\xEA\x29\x86\xBD\x28\xF2\xE6\x08\x82\x98\xC0\xD2\x33\xBF\x09\x19\x60\x2F\xC2\xB1\xDA\x53\x09\xC7\x58\x14\xAB\xAA\x02\xBA\x4A\x86\xAB\xBD\x38\x24\x8C\x09\x0D\xD0\x8A\x20\x59\xCA\x19\x66\x02\x1B\x55\x7A\x20\x1B\x56\xBE\x0E\x38\x69\x19\x0C\x91\x76\xEC\xA0\xC9\x0A\x88\x65\xA0\xD3\x3A\xDB\x46\xFF\x67\x47\x46\x5B\x1F\x43\x5A\x16\xCB\x53\xA1\xC6\xCA\x31\xEC\x85\x15\x08\x60\xEE\xB9\xE8\xA6\x7B\xAE\x05\x86\x1C\xD0\xD9\x95\x27\x44\x46\x51\x47\x3F\x8D\x6B\x87\xBA\xF8\xAA\xBB\xE7\xA2\x66\xFA\xC9\x47\xB1\x28\x68\xF9\x01\x45\xF1\x11\x7C\x27\xBF\x78\xEE\x8B\xF0\x99\xF2\x69\x7A\x82\xAE\x03\xDB\x5B\x6F\x09\x06\x7E\xB0\xB0\x9E\x17\x93\xE9\xAF\x21\x0E\x93\x00\x71\xC4\x14\x8B\x1B\xB2\x1D\x19\x93\xA9\x01\x00\x28\xA7\xAC\xF2\xCA\x29\x57\x20\x1F\xB8\x40\xDE\x21\xF1\x21\x33\x97\xC1\xF2\xCD\x2C\x9F\x08\xB3\x8A\x34\x8F\x3C\x31\x09\x15\x6B\xFB\xDC\x48\xB0\x09\x62\xB0\xCC\x3E\x0B\x4D\x1F\x45\xCE\xB0\xE9\xC1\x31\x47\xFF\x4C\xAA\xD2\xF5\x41\x04\x2B\xD2\x24\x70\x12\x75\xCF\x40\x53\x4D\x9F\xD3\x02\x7B\x64\x82\x69\xDC\x64\x29\x72\xD7\x5E\xBF\x3C\x73\xAE\xB9\xC9\x76\x69\xA2\x69\x9F\x3D\xC2\x91\x56\x1F\xD7\x76\x1B\xC8\x2E\xE9\xE9\x97\x90\xC6\x41\x51\x1C\xA4\xDC\xED\x1F\x09\x86\xEC\xFD\xA5\xC2\x17\x6F\x8C\xF5\x08\x80\x5F\x3D\xAA\x07\x94\xAA\xE6\x41\xA0\x6D\x94\x3C\x26\xE2\x0B\x2B\x2E\xB5\x07\x3D\x06\xDE\xCB\xAC\xC0\xDA\x7D\xB0\xFF\xE5\x98\x23\xAC\x39\xD7\x53\xDF\x1A\xB8\xA4\x56\x02\x57\xC2\xC7\x8A\x5A\xDE\x01\x86\x65\x8F\x40\x2F\xAA\x57\x7F\x10\x14\xB3\x63\xC7\x2D\x1F\x43\x10\x3B\x8C\x46\xED\x1E\xD0\x7B\x69\xD0\xBE\xD7\xF5\x56\xE8\x24\x74\x54\x6C\xAF\xC2\x96\x70\x6A\xF2\x76\x74\x66\x40\x02\x1C\x58\x4F\x46\xDD\x75\x76\x0C\x3B\xF5\xBC\xBB\x00\x31\x6C\x28\x20\x4F\x3D\x91\xFE\x1C\xB9\x56\x9B\xE0\xE3\xF6\x38\x0A\xB7\x8F\xD1\xB1\xF4\x6F\xB5\x6F\x08\x04\x3F\x7A\x60\x00\xA7\x8B\x4B\xCF\xBF\x85\xA5\xE3\xD7\xE9\xDA\x70\x00\x05\xF8\xC5\x00\x0A\x80\x1B\x19\x18\x10\x14\x0A\x28\xB0\x72\xB2\x0B\xE0\xA2\x06\x68\x87\x03\x0C\x60\x00\x0F\x8C\x83\x05\x2F\xC8\x1F\xD9\x75\x40\x82\x7D\xB2\x1F\x19\x3C\x78\x32\x9C\x99\xD0\x65\x22\xFC\x80\x09\x57\x98\xC2\x16\xBA\xF0\x85\x30\x8C\xA1\x0C\x67\xE8\xAB\x94\x9D\xCE\x86\x71\xA8\x00\x0E\xDB\xA0\x43\x94\xA1\xB0\x0C\x3D\x04\xC0\x0F\xA9\x36\x26\x00\x90\x4C\x4C\x46\x6C\x83\x00\x8A\x18\x87\x25\x8A\x49\x73\x4E\xEC\x00\x05\x7D\xC5\xC4\x38\x54\xB1\x0C\x51\x4C\x22\x16\x19\xA6\x44\x2E\x7A\xED\x8A\xB1\xEB\x80\x16\xC9\x90\xC5\xFF\x26\x7A\x91\x8C\x67\x54\x1A\x18\x47\x88\x44\x33\xB6\xB1\x8B\x4F\x74\xA3\x14\x1F\xB4\x01\x25\xFC\x8F\x3E\x6B\x1C\x43\x1E\xCB\x08\xC7\x39\xF6\x71\x8A\x7C\xB0\x89\x12\x62\x20\x9B\xFA\xE4\xD1\x62\x6F\xDC\x62\x22\xD1\x18\xC7\x3F\xAE\xCA\x20\xE1\x0A\xD0\x21\xF7\x48\xC9\x46\x2A\xD2\x8F\xFC\x71\x05\x21\x05\x34\xC9\x45\x8E\x81\x8F\x97\x84\x62\x1A\xE9\xA3\x49\x43\x49\xD2\x93\x7A\x44\x25\x28\x19\x89\x49\x56\x02\xD2\x36\x90\x2C\x24\x1E\x51\x89\x48\x31\xCA\x71\x8C\x9F\x1C\x65\x14\x5F\xD9\x1C\xC6\xC8\x72\x3E\x9D\xB4\x65\x1F\x71\xF9\x81\x5D\xCA\x91\x97\x6D\x08\xDD\x26\x4F\x29\x4C\x08\x36\x93\x95\xC4\x34\xA6\x23\x03\x14\x4B\x4E\xD2\xB2\x92\xCF\xCC\xA5\x25\x5D\xA9\x2C\xDE\x44\xB2\x3F\xC1\x8C\x26\x36\x45\xB9\xCD\xFD\x54\x93\x99\xC4\xAC\xA5\x38\x55\xA9\xCB\x51\xD2\x07\x92\xBE\x18\x5D\x3A\xB1\xB9\xCE\x56\x6A\xD3\x9E\x89\x59\x01\x7E\x5C\xE3\xCC\x79\xB2\xF3\x9F\xF8\x94\x66\xE3\x5A\xB0\x4F\x53\x5A\xF1\x9A\x00\xAD\x27\x39\xF1\x59\x19\x15\x1C\x00\x01\x10\x8D\xA8\x44\x23\xAA\xC0\x08\x58\x34\x03\x76\xB0\x68\x04\x30\xDA\x06\x0B\x68\x13\x94\xA3\x65\xF0\xA8\x45\xD9\xD5\x51\x8D\x92\x34\x0E\x13\x4D\x69\x44\x43\x00\x00\x3B";
const int elogo_gif_len = 1686;
/*content and length of "/dynamic/bg.gif"*/
const char* const bg_gif = "\x47\x49\x46\x38\x39\x61\x02\x00\x7C\x02\xF7\x00\x00\xFF\xFF\xFF\xDD\xEC\xF5\xF9\xFC\xFD\xDF\xED\xF6\x0C\x78\xB8\xEB\xF4\xF9\xF2\xF8\xFB\xEE\xF6\xFA\xF3\xF8\xFC\xFC\xFD\xFE\x05\x74\xB6\x03\x73\xB6\x02\x72\xB6\xF6\xFA\xFC\x0D\x78\xB9\x34\x8E\xC4\xFA\xFC\xFE\xE9\xF3\xF9\xFB\xFD\xFE\x2B\x89\xC1\x14\x7C\xBB\x0A\x77\xB8\x06\x74\xB7\xE3\xEF\xF7\xCB\xE2\xF0\x01\x72\xB5\xF0\xF7\xFB\x0F\x79\xB9\xF5\xF9\xFC\x20\x83\xBE\x25\x86\xC0\xFE\xFE\xFF\xD4\xE7\xF3\x09\x76\xB8\x11\x7A\xBA\x1C\x81\xBD\x08\x75\xB7\x19\x7F\xBC\xDA\xEA\xF4\x00\x59\x8F\x16\x7D\xBB\xF7\xFB\xFD\xFD\xFE\xFE\xE6\xF1\xF8\x04\x73\xB6\x75\xB2\xD7\x6C\xAD\xD4\x24\x85\xBF\xE1\xEE\xF6\x23\x84\xBF\x6B\xAD\xD4\xB2\xD4\xE9\x74\xB2\xD7\x8C\xBF\xDE\xE0\xEE\xF6\x3C\x92\xC6\x77\xB3\xD8\xC1\xDC\xED\x65\xA9\xD2\x02\x72\xB5\x6E\xAE\xD5\xB3\xD5\xE9\x61\xA7\xD1\x69\xAB\xD3\xCE\xE4\xF1\x9B\xC7\xE2\x57\xA1\xCE\x52\x9F\xCD\x58\xA2\xCF\x62\xA8\xD1\xA8\xCF\xE6\x7E\xB7\xDA\xC9\xE1\xEF\x82\xB9\xDB\x7B\xB5\xD9\xC0\xDC\xED\x00\x71\xB5\x98\xC6\xE1\x8B\xBE\xDD\x33\x8D\xC4\xBE\xDB\xEC\xCD\xE3\xF0\x72\xB0\xD6\x50\x9E\xCC\xBD\xDA\xEC\xBB\xD9\xEB\x45\x97\xC9\x7D\xB7\xD9\xCF\xE4\xF1\xA5\xCD\xE5\x9A\xC7\xE2\xAD\xD1\xE7\x4E\x9C\xCC\xA9\xCF\xE6\xAC\xD1\xE7\x59\xA3\xCF\xA4\xCC\xE5\x3D\x93\xC7\x4F\x9D\xCC\xEF\xF6\xFA\xD1\xE5\xF2\x06\x72\xB3\x56\xA1\xCE\xB5\xD6\xEA\x70\xAF\xD6\xC2\xDD\xED\xDB\xEB\xF5\x4C\x9B\xCB\x3F\x94\xC7\x9C\xC8\xE2\x7A\xB5\xD8\x22\x84\xBF\xA2\xCB\xE4\xB7\xD7\xEA\x2C\x8A\xC2\x09\x6E\xAB\xD2\xE6\xF2\x8A\xBE\xDD\x84\xBB\xDB\xC6\xDF\xEE\x1B\x80\xBD\x68\xAB\xD3\x43\x96\xC8\xB1\xD4\xE8\x6F\xAF\xD5\x6A\xAC\xD4\x73\xB1\xD6\x3B\x92\xC6\xD3\xE6\xF2\x31\x8C\xC3\x2D\x8A\xC2\x27\x87\xC0\xC4\xDE\xEE\xD7\xE9\xF3\x81\xB9\xDA\xAE\xD2\xE7\x08\x71\xB0\x7C\xB6\xD9\x88\xBD\xDC\x41\x95\xC8\xB6\xD6\xEA\x89\xBD\xDD\xBC\xDA\xEC\x90\xC1\xDF\xE5\xF1\xF7\x94\xC3\xE0\x63\xA8\xD2\x1E\x82\xBE\x1F\x82\xBE\x53\x9F\xCD\x93\xC3\xE0\x08\x6A\xA4\xE7\xF2\xF8\xE4\xF0\xF7\xEC\xF4\xF9\xB8\xD7\xEA\x21\x83\xBF\x06\x64\x9C\x40\x95\xC8\x4D\x9C\xCB\x5B\xA4\xCF\xD8\xE9\xF4\xD9\xEA\xF4\x38\x90\xC5\x39\x91\xC6\x3A\x91\xC6\x48\x99\xCA\xAF\xD2\xE8\xB4\xD5\xE9\x13\x7C\xBB\x0B\x77\xB8\x28\x87\xC1\x83\xBA\xDB\x17\x7E\xBC\xC3\xDE\xEE\x37\x90\xC5\x9F\xCA\xE3\x8F\xC1\xDE\x54\xA0\xCD\xED\xF5\xFA\x29\x88\xC1\x76\xB3\xD7\xA6\xCD\xE5\xA7\xCE\xE5\x1D\x81\xBD\x9D\xC8\xE3\xD0\xE5\xF1\xB0\xD3\xE8\xDE\xED\xF5\x67\xAA\xD3\x7F\xB8\xDA\x9E\xC9\xE3\x87\xBC\xDC\xEA\xF3\xF9\x99\xC6\xE1\x12\x7B\xBA\xF8\xFB\xFD\x36\x8F\xC5\x35\x8F\xC4\x1A\x7F\xBD\x55\xA0\xCE\xBF\xDB\xEC\x42\x96\xC8\x78\xB4\xD8\x96\xC5\xE1\xE8\xF2\xF8\x97\xC5\xE1\x85\xBB\xDC\x15\x7D\xBB\x2A\x88\xC1\x49\x9A\xCA\x07\x75\xB7\xCC\xE3\xF0\x71\xB0\xD6\x10\x7A\xBA\x03\x5E\x94\x5A\xA3\xCF\xF1\xF7\xFB\xB9\xD8\xEB\x51\x9E\xCD\xCA\xE1\xF0\x30\x8C\xC3\xA0\xCA\xE3\x47\x99\xCA\x0E\x79\xB9\xC5\xDF\xEE\xF4\xF9\xFC\xD5\xE8\xF3\xE2\xEF\xF7\x95\xC4\xE0\x32\x8D\xC4\x18\x7E\xBC\x8D\xC0\xDE\x5D\xA5\xD0\x5E\xA5\xD0\x5F\xA6\xD1\xC7\xE0\xEF\xC8\xE0\xEF\x8E\xC0\xDE\x3E\x94\xC7\x4A\x9A\xCA\x4B\x9B\xCB\xA1\xCB\xE4\x66\xAA\xD3\x2E\x8B\xC2\x2F\x8B\xC3\x64\xA9\xD2\x60\xA6\xD1\x46\x98\xC9\x26\x86\xC0\xBA\xD9\xEB\xD6\xE8\xF3\x80\xB8\xDA\x44\x97\xC9\x91\xC2\xDF\xAA\xD0\xE6\x21\xF9\x04\x00\x00\x00\x00\x00\x2C\x00\x00\x00\x00\x02\x00\x7C\x02\x40\x08\xFF\x00\x4F\x9C\xD8\xB1\x83\x05\x0B\x12\x24\x1C\x38\x18\x36\xEC\xDC\xB9\x49\x93\x3C\x78\x98\x30\xE1\xC9\x93\x52\xA5\x94\x29\x83\x07\x6F\xC8\x10\x6C\xD8\x24\x49\x92\x21\x83\x06\x8D\x2B\x57\x9E\x3D\x73\xE7\xCE\x99\x33\x58\xB0\x8C\x18\xD9\xB5\x6B\xD3\xA6\x25\x4B\xDA\xB5\xC3\x82\x65\xDF\xBE\x00\x01\x2E\x5C\x88\x10\x61\xCC\x18\x71\xE2\x04\x08\x50\xA1\x02\x80\xD3\xA7\x50\xA3\x4A\x9D\x4A\xB5\xAA\xD5\xAB\x58\xA5\x5E\xBA\xC4\x80\x81\x05\x0B\x15\x2A\x6C\xD8\x00\x0D\x1A\x1E\x3C\x9C\x38\xAD\x5A\x55\xAF\x5E\xB1\x62\xEF\xDE\xE1\xC3\xC7\x85\x8B\x19\x33\xEB\xD6\xF5\xEA\x85\x06\xCD\xB2\x65\x86\x0C\xD5\xA9\x63\xC9\x52\x90\x20\x60\xC0\x78\xF1\x82\x0A\x95\x23\x47\x84\x08\x61\xC0\x00\x08\x90\x09\x13\x36\x6C\xAC\x58\xA1\x49\x93\x01\x03\x0D\x1A\x48\x90\x90\xB5\xB4\xE9\xD3\xA8\xAB\x5E\xBB\x86\x08\x51\x86\x0C\x0B\x16\x28\x50\x30\x6D\x5A\x88\x10\x04\x08\x80\x03\x27\x42\x04\x05\x0A\x28\x50\x94\x28\x31\x62\x44\x87\x0E\x31\x62\xE4\xCB\x17\x2D\x9A\x20\x41\x81\x02\x3D\x78\x30\x6A\xD4\x8D\x1B\x9E\x3C\xF5\xEB\x67\xCA\xD4\x9A\x35\x53\xA6\xC8\xFF\x92\x45\x84\x48\xBA\x74\x3E\x7C\xE8\xD0\xF1\xE3\x07\x0F\x1E\x52\xA4\xD4\xAA\xA5\x44\x89\x2F\x5F\xAC\x58\x29\x52\x54\xA3\xC6\xA3\x47\xE5\x94\x23\x8C\x30\xB9\xE4\x22\x8F\x3C\xB6\xD8\xF2\xCF\x3F\x87\x1C\x32\xC3\x0C\x8C\x30\xA2\x8F\x3E\x50\x40\x91\x46\x1A\x77\xDC\xC1\x0D\x37\x51\x44\x41\x06\x19\x20\x80\x10\x4A\x28\x6A\xA8\x31\xC0\x00\xE4\x90\x03\x09\x24\xCD\x34\x53\x40\x01\x07\x1C\xA0\x81\x06\x08\x20\xC0\x01\x07\x29\xA4\x00\x01\x04\x09\x24\xF0\xC1\x07\xA9\x05\x29\xE4\x90\x44\x16\x69\xE4\x90\x02\x75\xD2\xC9\x1C\x73\x94\x51\x06\x13\x4C\xBC\xD6\x55\x6C\x06\xCD\xF6\x15\x42\xB7\x85\xA5\x8A\x2A\xB9\x29\x34\x96\x35\xD6\xF4\x96\x4A\x2A\xBF\x05\xD7\x4A\x2B\xC3\x1D\x73\x4C\x71\xB8\xE0\x42\x09\x25\xC7\xBD\xF1\xC6\x0B\x2F\x48\x34\xC8\x20\xB4\xD0\x42\x91\x1C\x72\xD0\x43\x4F\x37\xDD\x98\x63\xCE\x74\xC6\x18\xF3\xCA\x2B\xA4\x90\xF2\xC7\x1F\x61\x84\xC1\x06\x1B\x8B\x2C\xA2\x87\x1E\x56\x58\xF1\xCD\x37\xD2\x48\x13\x4F\x3C\x9F\x7C\x22\x86\x18\xDB\x6C\x53\x49\x25\xC8\x20\x23\x84\x10\x5F\x7C\x01\x0A\x28\xEA\xA8\x73\xCF\x3D\x45\x14\xCB\x61\x8F\x3D\xF3\xCC\x93\x47\x1E\x7D\xF4\xE1\x82\x0B\x7C\xF0\x51\x4D\x35\x7E\xF8\xD1\x42\x0B\x38\xE0\xE0\x86\x1B\x89\x24\x72\xC4\x11\xFC\xF0\x93\x44\x12\x76\xD8\x01\x0C\x30\x8D\x34\xE2\x84\x13\xE8\xA0\x13\x4B\x2C\xFE\xF8\x13\x49\x24\xCC\x30\xD3\x44\x13\x5A\x68\xD1\x46\x1B\xBF\xFC\xE2\x8D\x37\x70\xC0\x91\x45\x16\xB7\xDC\xD2\x45\x17\x0B\x6E\xB1\xC5\x29\xA7\xEC\xB1\x47\x0F\x3D\x9C\x71\x46\x1C\x71\x68\xA3\x4D\x15\x55\x50\x41\x45\x32\xC9\xE4\x90\x83\x2B\xAE\x84\x13\x0E\x3B\xEC\x20\x81\xC4\x64\xD4\x50\x03\x04\x10\xBA\xE8\x42\x07\x1D\x21\x8E\x33\x4E\x21\x85\x88\x22\xCA\x65\x40\xF1\xC2\xCB\x89\x30\xC0\x20\x54\x26\x99\x6C\x86\x09\x26\x44\x05\x13\xCC\x8B\xB3\xCC\x12\xE3\x8C\xD9\x64\xF3\x59\x8D\x37\x86\x96\x23\x31\xC4\x28\xB5\xE3\x68\x3D\x32\xF5\xE3\x91\x48\x27\xAD\xF4\xD2\x4C\x37\xED\xF4\xD3\x50\x47\x2D\x55\x40\x00\x3B";
const int bg_gif_len = 1518;
/*content and lenght of "/dynamic/favicon.ico"*/
const char* const favicon_ico = "\x00\x00\x01\x00\x01\x00\x10\x10\x10\x00\x01\x00\x04\x00\x28\x01\x00\x00\x16\x00\x00\x00\x28\x00\x00\x00\x10\x00\x00\x00\x20\x00\x00\x00\x01\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xC8\x77\x31\x00\x9E\xBF\x39\x00\xEF\x9E\x58\x00\xFC\xA7\x52\x00\xFF\xA4\x54\x00\xFF\xF4\xC2\x00\xFF\xFF\xFF\x00\xC0\xC0\xC0\x00\x00\x00\xFF\x00\x00\xFF\x00\x00\x00\xFF\xFF\x00\xFF\x00\x00\x00\xFF\x00\xFF\x00\xFF\xFF\x00\x00\xFF\xFF\xFF\x00\x11\x72\x72\x72\x72\x72\x71\x10\x17\x72\x72\x72\x72\x72\x77\x10\x77\x72\x72\x72\x72\x72\x77\x70\x22\x77\x77\x77\x77\x77\x22\x20\x77\x77\x61\x64\x11\x77\x77\x70\x22\x77\x17\x53\x71\x77\x22\x20\x77\x77\x16\x53\x71\x77\x77\x70\x22\x77\x11\x53\x71\x77\x22\x20\x77\x77\x17\x53\x71\x77\x77\x70\x11\x77\x61\x64\x11\x77\x11\x10\x11\x11\x11\x11\x11\x11\x11\x10\x17\x71\x76\x77\x17\x71\x71\x10\x17\x11\x71\x71\x17\x11\x71\x10\x17\x61\x71\x16\x17\x61\x71\x10\x17\x71\x71\x77\x17\x77\x77\x10\x11\x11\x11\x11\x11\x11\x11\x10\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04\x00\x01\xF3\x04";
const int favicon_ico_len = 318;

/*content of "/dynamic/Cstyle.css"*/
const char* const static_css =
"/* Main Style sheet for the ELZET80 */"
"body{font: 100% Arial,Helvetica,sans-serif;    text-align: center; margin: 0; background: #FFF; color: #000;}"
"#container{width: 100%;}"
"#header{clear: both; width: 80%; min-width: 500px; margin: 0 auto; height:130px; padding: 10px 0 0; color:#999;}"
"#main-outer{float: left; clear: both; width: 100%;background: #FFF url(/dynamic/bg.gif) repeat-x;}"
"#main{clear: both; width: 90%; min-width: 500px; margin: 0 auto; text-align: left; padding: 0 10px;}"
"#footer{width: 100%; background: #BBB; clear:both; font-size: 10pt; color: #555;}"
"img{border: none;}"
".left{float: left;}"
".right{float: right;}"
".left-align{text-align: left;}"
".right-align{text-align: right;}"
".center-align{text-align: center;}"
".lf{clear: both; margin: 0;    padding: 5px 0;}"
".block1{float: left; display: block; width: 225px; padding: 0 10px; margin: 0 0 10px;}"
".block2{float: left; display: block; width: 470px; padding: 0 10px; margin: 0 0 10px;}"
".block100{float: left; display: block; width: 98%; padding: 0 1%; margin: 0 0 10px;}"
".max750{max-width: 750px;}"
".max850{max-width: 850px;}"
".form-table{width: 100%; border: 1px solid #AAA; margin: 5px 0 0; text-align: left; border-collapse: collapse;}"
".form-table tr td, .form-table tr th{padding: 5px;}"
".margin-top-10{margin-top: 10px;}"
".no-border{border: none;}"
".border-td tr td, .border-td tr th{border: 1px solid #AAA;}"
"legend{font-weight: bold;}"
"#header #logo{float: left; display: block;}"
"#header #title{font-size: 18pt; float: left; margin: 15px 0  0 20px; display: block;}"
"#header #text{float: right; text-align: left; display: block;}"
"#menu-block{float: left; display: block; }"
"#home-page-img img{float: right; display: block; max-width: 300px;}"
"#main h1{float: left; clear: both; color: #FFF;}"
"#main h2{float: left; clear: both; color: #FFF; margin: -10px 0 10px; padding: 0;}"
"#menu{margin: 0;}"
"ul li{list-style-type: circle; padding: 3px;}"
"#footer p {margin: 0; padding: 10px 0 10px 15px;}"
"#footer a {color:#009898;}"
".io-user-outputs td{text-align: center; font-weight: bold; font-size: 26px; padding: 5px 0; cursor: hand;}"
".io-user-outputs td:hover{background: #CCC;}";


/*header-part of the dynamically generated analog-input website*/
const char* const  analog_header =
    "<html xmlns=\"http://www.w3.org/1999/xhtml\">"
    "<head>"
    "<title>Welcome to mbed\'s Web Page!</title>"
    "<meta http-equiv=\"Content-Type\"content=\"no-cache\"content=\"text/html; charset=ISO-8859-1\" />"
    "<link rel=\"shortcut icon\" href=\"/dynamic/favicon.ico\" />\n"
    "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"/dynamic/Cstyle.css\" />\n"
    "</head>"
    "<body>"
    "<div id=\"container\">"
    "<div id=\"header\">"
    "<div id=\"logo\"><a href=/index.htm><img src=\"/dynamic/Elogo.gif\" alt=\"ELZET80\" title=\"Go to home page\" /></a></div>"
    "<div id=\"title\">Welcome Elzet 80 mbedRail24v Demo</div>"
    "<div id=\"text\">"
    "<p>Running ELZET80 mbed demo</p>"
    "</div>"
    "</div>"
    "<div id=\"main-outer\">"
    "<div id=\"main\">";

/*header-part of the dynamic generated io website*/
const char* const io_header =
    "<html xmlns=\"http://www.w3.org/1999/xhtml\">"
    "<head>"
    "<title>Welcome to mbed\'s Web Page!</title>"
    "<meta http-equiv=\"Content-Type\"content=\"no-cache\"content=\"text/html; charset=ISO-8859-1\" />"
    "<link rel=\"shortcut icon\" href=\"/dynamic/favicon.ico\" />\n"
    "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"/dynamic/Cstyle.css\" />\n"
    "<script type=\"text/javascript\">\n"
    "function key(id){\n"
    "var out=\"io.htm?o\"+id;location.href=out}\n"
    "</script>\n"
    "</head>"
    "<body>"
    "<div id=\"container\">"
    "<div id=\"header\">"
    "<div id=\"logo\"><a href=/index.htm><img src=\"/dynamic/Elogo.gif\" alt=\"ELZET80\" title=\"Go to home page\" /></a></div>"
    "<div id=\"title\">Welcome Elzet 80 mbedRail24v Demo</div>"
    "<div id=\"text\">"
    "<p>Running ELZET80 mbed demo</p>"
    "</div>"
    "</div>"
    "<div id=\"main-outer\">"
    "<div id=\"main\">";

/*footer of the dynamic generatred analog and io webpages*/
const char* const io_footer=
    "</div>"
    "</div>"
    "</div>"
    "<div id=\"footer\">"
    "<p>&copy; 2012 &nbsp; ELZET80 Mikrocomputer GmbH&Co. KG &bull; Aachen &bull; <a href=\"http://www.elzet80.de\">www.elzet80.de</a></p>"
    "</div>"
    "</div>"
    "</body>"
    "</html>";
    
/*content of index.html*/
const char* const index_html =
    "<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n"
    "<head>\r\n"
    "<title>Welcome to mbed\'s Web Page!</title>\r\n"
    "<meta http-equiv=\"Content-Type\"content=\"no-cache\"content=\"text/html; charset=ISO-8859-1\" />\r\n"
    "<link rel=\"shortcut icon\" href=\"/dynamic/favicon.ico\" />\r\n"
    "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"/dynamic/Cstyle.css\" />\r\n"
    "</head>\r\n"
    "<body>\r\n"
    "\r\n"
    "<div id=\"container\">\r\n"
    "\r\n"
    "<div id=\"header\">\r\n"
    "<div id=\"logo\"><img src=\"/dynamic/Elogo.gif\" alt=\"ELZET80\" title=\"Home page\" /></div>\r\n"
    "<div id=\"title\">Welcome Elzet 80 mbedRail24v Demo</div>\r\n"
    "<div id=\"text\">\r\n"
    "<p>Running ELZET80 mbed demo</p>\r\n"
    "</div>\r\n"
    "</div>\r\n"
    "\r\n"
    "<div id=\"main-outer\">\r\n"
    "<div id=\"main\">\r\n"
    "<h1>Main menu </h1>\r\n"
    "<div class=\"lf\">\r\n"
    "<div id=\"menu-block\">\r\n"
    "<ul id=\"menu\">\r\n"
    "<li><a href=\"/dynamic/io.htm\">Digital I/O Page</a></li>\r\n"
    "<li><a href=\"/dynamic/analog.htm\">Analog Input Page</a></li>\r\n"
    "</ul>\r\n"
    "</br>\r\n"
    "</div>\r\n"
    "</div>\r\n"
    "</div>\r\n"
    "</div>\r\n"
    "\r\n"
    "<div id=\"footer\">\r\n"
    "<p>&copy; 2012 &nbsp; ELZET80 Mikrocomputer GmbH&Co. KG &bull; Aachen &bull; <a href=\"http://www.elzet80.de\">www.elzet80.de</a></p>\r\n"
    "</div>\r\n"
    "\r\n"
    "</div>\r\n"
    "\r\n"
    "</body>\r\n"
    "</html>";

/*definition of constants for hardware abstraction (enables compatibility to "ELZET80 kbed uTasker Platform")*/
const char ASCII_out = '0';         // 0-9 for output ports
const char ASCII_in = 'a';          // a-f for input ports
const char ASCII_analog = '0';      // 0-9 for analog input

  

/*----------------------------------------------------------------------------
 *      io functions
 *---------------------------------------------------------------------------*/
 
/*assign mbed Rail24V io-ports to LPC1768 io ports*/

/*ASCII-characters are only relevant for use with http handling routines*/
DigitalOut out1(p23, 1);                   //Output 1   --> ASCII "1"
DigitalOut out2(p24, 1);                   //Output 2   --> ASCII "2"
DigitalOut out3(p25, 1);                   //Output 3   --> ASCII "3"
DigitalOut out4(p26, 1);                   //Output 4   --> ASCII "4"
DigitalOut relay1(p22, 0);                   //Relais     --> ASCII "5"
DigitalOut led1(LED1, 0);                  //MBED led1 - activated in "boot sequence" // blink: led1 (by timer-interrupt ticker)
DigitalOut led2(LED2, 0);                  //MBED led2 - activated in "boot sequence" // blink: led2 (by led2_thread)
DigitalOut led3(LED3, 0);                  //Mbed led3
DigitalOut led4(LED4, 0);                  //MBED led4
DigitalIn in1(p19);                        //Input 1    --> ASCII "a"
DigitalIn in2(p20);                        //Input 2    --> ASCII "b"
DigitalIn in3(p11);                        //Input 3    --> ASCII "c"
DigitalIn in4(p12);                        //Input 4    --> ASCII "d"
AnalogIn ain1(p15);                        //Analog Input 1 --> ASCII "1"
AnalogIn ain2(p16);                        //Analog Input 2 --> ASCII "2"
AnalogIn ain3(p17);                        //Analog Input 3 --> ASCII "3"
AnalogIn ain4(p18);                        //Analog Input 4 --> ASCII "4"


DigitalOut rs485_txmode(p21, 0);           //RS485 - enable receiver (Port 21: 0 recieve mode / 1 transmit mode)

//Serial interfaces
//Pins        UART
//USBTX,USBRX 0
//p13,p14     1
//p28,p27     2
//p9,p10      3

RawSerial rs232(p9, p10);  // tx, rx -- rawserial is used for compatibility with interrupt routines
RawSerial rs485(p13, p14);  // tx, rx


LocalFileSystem local("local");             //initialize the local file system

Ticker interruptTick;                        //create a timer

/*httpd*/
HTTPD *httpd;                               //initialize the httpd-webserver


/*----------------------------------------------------------------------------
 *      functions
 *---------------------------------------------------------------------------*/
 
 
void index_website_handler (int id);
void dynamic_website_handler (int id);

void dynamic_IO_website(int id);
void dynamic_analog_website(int id);

int io_webhandler_action(char *input_buf, int input_puf_len);

unsigned short read_adc(char port_name);
int read_portval(char port_name);
int write_portval(char port_name, int port_val);
int toggle_port(char port_name);



/*----------------------------------------------------------------------------
 *      interrupt and thread functions
 *---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*
 * Routine:  echoRS232 (interrupt)
 *---------------------------------------------------------------------------*
 * Description:
 *
 *      Toggle LED3 to indicate RS232 activity.
 *      Read a char from the rs232 input port to a buffer and
 *      send the char to rs232 port.
 *---------------------------------------------------------------------------*/
void echoRS232() {
    char rs232_buffer = 0;                  //local buffer
    
    led3 = !led3;                           //toggle LED3
    
    /*read rs232 buffer and write the result back to rs232 interface*/
    if (rs232.readable()){                  //avoid hanging up the program in case of multiple use of rs232
       
       rs232_buffer =  rs232.getc();        //read input to buffer
       
        if (rs232.writeable()){   
            rs232.putc(rs232_buffer);       //write buffer to rs232 output
        }
    }
    return;     
}

/*---------------------------------------------------------------------------*
 * Routine:  echoRS485  (interrupt)
 *---------------------------------------------------------------------------*
 * Description:
 *      Toggle LED3 to indicate RS485 activity.
 *      Read a char from the RS485 input port to a buffer, switch RS485 port
 *      to transmission mode and send the buffered char to RS485 port.
 *---------------------------------------------------------------------------*/
void echoRS485() {
    char rs485_buffer = 0;              //local buffer
    
    led3 = !led3;                       //toggle LED
    
    rs485_txmode = 1;                   //enable RS485 transmission mode 
    
    //read rs485 inpuf buffer and write the result back to rs485 interfacee
    if (rs485.readable()){
       
       rs485_buffer =  rs485.getc();
       
        if (rs485.writeable()){   
            rs485.putc(rs485_buffer);
        }
    }
}

/*---------------------------------------------------------------------------*
 * Routine:  enableRS485receiver  (interrupt)
 *---------------------------------------------------------------------------*
 * Description:
 *      Disable RS485 transmission mode. (TxIRQ -> tx buffer empty)
 *---------------------------------------------------------------------------*/
void enableRS485receiver() {
     rs485_txmode = 0;                  //disable RS485 transmission mode
    }


/*---------------------------------------------------------------------------*
 * Routine:  interruptTickRoutine
 *---------------------------------------------------------------------------*
 * Description:
 *      Toggle LED1.
 *---------------------------------------------------------------------------*/
void interruptTickRoutine() {
    led1 = !led1;
    return;
}


/*---------------------------------------------------------------------------*
 * Routine:  led2_thread
 *---------------------------------------------------------------------------*
 * Description:
 *      Example for a thread. Toggle LED2 and sleep 1000ms.
 *---------------------------------------------------------------------------*/
void led2_thread(void const *args) {
    while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}



 



/*----------------------------------------------------------------------------
 *      main ()
 *---------------------------------------------------------------------------*/
int main() {
    
    #if defined debug
        printf("Welcome to ELZET80 mbed demo\r\n");                     //print debug Informations to LPC1768 USB-Comport (9600 baud)
    #endif
    
    /*Example to write a file to the local filesystem:
    
        FILE *fp = fopen("/local/helloworld.txt", "w");  // Open "helloworld.txt" on the local file system for writing
        fprintf(fp, "Hello World!");
        fclose(fp);
    */

    led1=1;          //enable status led1
    
    /*Ethernet initialisation - the demo would not start without an ethernet connection*/
    EthernetInterface eth;
    
    #if defined dhcp_disable
        static const char* netIP = "192.168.17.73";
        static const char* netMask = "255.255.255.0";
        static const char* netGateway = "192.168.17.73"; 
        eth.init(netIP,netMask,netGateway);                 //use userpecific IP, Netmask and Gateway
    #else
         eth.init();                                        //use DHCP client function
    #endif
    
    #if defined debug
        printf("starting Ethernet Interface setup\r\n");
    #endif
    
    int ethError;                                   //Ethernet error buffer
    
    /*start ethernet connection*/
    do{
        ethError = eth.connect(5000);               //connect to network with 5s (5000ms) timout
        #if defined debug
            if(ethError)printf("Error %d occurrenced \r\n", ethError);
        #endif
        wait(1);
    }while(ethError != 0);                          //wait until a network connection was established
    
    
    led2 = 1;                                       //set status led2 
    
   #if defined debug
        printf("\r\nEthernet Interface setup finished. IP: %s\r\n", eth.getIPAddress());
        printf("enabling RS232/RS485 echo mode ... \r\n");
    #endif
    
    
    /*init serial ports*/
    rs232.baud(9600);                                                   //set rs232 baudrate to 9600
    rs232.printf("Enabled RS232 port - starting echo mode \r\n");
    rs232.attach(&echoRS232,Serial::RxIrq);                             //attach the rs232 echo function to rs232 rx interrupt
    
    rs485.attach(&enableRS485receiver,Serial::TxIrq);                   //enable automatic rx/tx switching (tx-buffer empty interrupt)
    rs485_txmode = 1;                                                   //enable RS485 transmission mode
    rs485.baud(9600);                                                   //set rs485 baudrate to 9600 baud
    rs485.printf("Enabled RS485 port - starting echo mode \r\n");
    rs485.attach(&echoRS485,Serial::RxIrq);                             //enable echo mode via RS485 echo routine
    
 
    httpd = new HTTPD;
    httpd->attach("/dynamic/", &dynamic_website_handler);               //use the function "dynamic_website_handler" for handling the dynamic websites 
                                                                        //initialize all virtual directories before the root directory
    httpd->attach("/flash/", "/local/");                                //attach the flash storage ("local") to http://mbed.ip/flash/  -- currently the flash file system handler could not handle subdirectories!
    
    httpd->attach("/", &index_website_handler);                         //index.html
                        
    
    httpd->start(80);                                                   //httpd on port 80
    
    
    #if defined debug
        printf("Webserver started.\r\n");
    #endif
    
    
    #if defined debug
        printf("enabling Ticker for led1 and Thread for led2 \r\n");
    #endif
    
    interruptTick.attach(&interruptTickRoutine,0.5);                      //enabling Ticker for timer interrupt triggered subroutine (.5s periodic toggling of led1)
    

    Thread led2Thread(led2_thread, NULL, osPriorityNormal, 1024 * 4);   //create a separate thread
    
    //endless loop - "httpd-thread"
    while(1){
        Thread::wait(5);                                                //wait 5 ms
        
        
        /*handle waiting http requests*/
        /* the program waits here until a request was made and answered*/
        
        httpd->poll();                                                  //poll httpd for incoming requests
        
        led3 = !led3;                                                   //toogle led3 (indicate that a http request was handled)

    }
}
/*  end of main() */





/*----------------------------------------------------------------------------
 *      website handling functions
 *---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*
 * Routine:  index_website_handler
 *---------------------------------------------------------------------------*
 * Description:
 *      Website hander for handling requests of "http://mbed.ip/ *** ".
 *
 * Inputs:
 *      int id                  -- number of httpd web handler
 * Outputs:
 *      none                    -- only output to web browser
 *---------------------------------------------------------------------------*/
void index_website_handler (int id) {
    char input_buf[256];                                                //create an input buffer

    strcpy(input_buf, httpd->getFilename(id));                          //copy requested file name to buffer
    
    #if defined debug
    printf("index website handler -- handler-id:%d reqested file:%s\r\n", id, input_buf);
    #endif
    
    httpd->send(id, index_html, strlen(index_html), "Content-Type: text/html\r\n");         //transmit content of "index_html" to browser

}
    

/*---------------------------------------------------------------------------*
 * Routine:  dynamic_website_handler
 *---------------------------------------------------------------------------*
 * Description:
 *      Website hander for handling requests of "http://mbed.ip/dynamic/ *** ".
 * Inputs:
 *      int id                  -- number of httpd web handler
 * Outputs:
 *      "http"                  -- output to web browser
 *---------------------------------------------------------------------------*/
void dynamic_website_handler (int id) {
    char input_buf[256];                                //buffer for request parameters

    strcpy(input_buf, httpd->getFilename(id));          //copy request to buffer
    
    #if defined debug
    printf("dynamic website handler -- handler-id:%d  reqested file:%s\r\n", id, input_buf);
    #endif
    
    /*process the request*/
    if(strcmp (input_buf, "Elogo.gif") == 0) {
        httpd->send(id, elogo_gif, elogo_gif_len, "Content-Type: image/gif\r\n");
    } else if(strcmp (input_buf, "bg.gif") == 0) {
        httpd->send(id, bg_gif, bg_gif_len, "Content-Type: image/gif\r\n");
    } else if(strcmp (input_buf, "Cstyle.css") == 0) {
        httpd->send(id, static_css, strlen(static_css), "Content-Type: text/html\r\n");
    } else if(strcmp (input_buf, "favicon.ico") == 0) {
        httpd->send(id, favicon_ico, favicon_ico_len, "Content-Type: image/x-icon\r\n");
    } else if (strcmp(input_buf, "io.htm") == 0){
        dynamic_IO_website(id);
    } else if(strcmp (input_buf, "analog.htm") == 0) {
        dynamic_analog_website(id);
    } else{    
        httpd->httpdError(id, 404);
    }
}


/*---------------------------------------------------------------------------*
 * Routine:  dynamic_analog_website
 *---------------------------------------------------------------------------*
 * Description:
 *      Generation and handling of the dynamic website for digital ports.
 * Inputs:
 *      int id                  -- number of httpd web handler
 * Outputs:
 *      "http"                  -- output to web browser
 *---------------------------------------------------------------------------*/
void dynamic_IO_website(int id){
    char out_buf[2000];                                                 //buffer for website output (buffer size is minimized to max. required size)
    char query_buf[256];                                                //buffer to store 
    char tempstring[32];                                                //buffer for small string construction
    int counter = 0;                                                    //counter variable (multiple use)
    
    strcpy(query_buf, httpd->getQueryString(id));                       //copy transmitted parameters to query_buf
    strcpy(out_buf, io_header);                                         //initialize Website output
    
    io_webhandler_action(query_buf, strlen(query_buf));                 //handle transmitted parameters stored in query_buf
    
    
    /*create website in buffer*/
    strcat(out_buf,"<h1>View and Control Ports</h1><div class=\"lf\"><div class=\"block2\"><fieldset><legend>I/OPorts</legend>");
    
    strcat(out_buf,"<table class=\"form-table border-td\"><tr><th colspan=\"5\" class=\"center-align\">Outputs</th></tr><tr class=\"center-align\"><td>OUT1</td><td>OUT2</td><td>OUT3</td><td>OUT4</td><td>RELAY</td></tr><tr class=\"center-align\">");
    
    /*read status of output ports*/
    for(counter = 1; counter <= 5; counter++){
           strcat(out_buf,"<th style=\" background-color:");
           if (read_portval(ASCII_out + char(counter))){
                strcat(out_buf,"gold");
            }else{
                strcat(out_buf,"lime");
            }
            strcat(out_buf,"\" onclick=\"key(\'");
            sprintf(tempstring,"%i\')\">O%i</th>",counter,counter);
            strcat(out_buf,tempstring);
        }
        
    strcat(out_buf, "</tr> </table>");
    strcat(out_buf, "<table class=\"form-table border-td\"><tr><th colspan=\"4\" class=\"center-align\">Inputs</th></tr><tr class=\"center-align\"> <td>IN1</td> <td>IN2</td><td>IN3</td><td>IN4</td></tr><tr class=\"center-align\">");
    
    /*read input values*/
    for(counter = 0; counter <= 3; counter++){                          //read port 1-4 (mapped to a-d)
        strcat(out_buf,"<th style=\" background-color:");
        if (read_portval(ASCII_in + char(counter))){ 
              strcat(out_buf,"gold");
        }else{
                strcat(out_buf,"lime");
        }
        sprintf(tempstring,"\">%i</th>",(counter+1));                   //port 1-4 mapped to a-d
        strcat(out_buf,tempstring);
    }
    strcat(out_buf,"</tr></table></div>");
          
    strcat(out_buf, io_footer);                                         //copy footer to buffer
    
    #if defined debug
        printf("io page html length: %i \r\n",strlen(out_buf));
    #endif
    
    httpd->send(id, out_buf, strlen(out_buf), "Content-Type: text/html\r\n");   //send the constructed website
    
}


/*---------------------------------------------------------------------------*
 * Routine:  dynamic_analog_website
 *---------------------------------------------------------------------------*
 * Description:
 *      Generation and handling of the dynamic website for analog ports.
 * Inputs:
 *      int id                  -- httpd web handle
 * Outputs:
 *      "http"                  -- only output to web browser
 *---------------------------------------------------------------------------*/
void dynamic_analog_website(int id){
    char out_buf[2000];                                                 //buffer for website output
    char query_buf[256];                                                //buffer to store 
    char tempstring[32];                                                //buffer for small string construction
    int counter = 0;                                                    //counter variable (multiple use)
    unsigned short analog_buf;                                          //buffer for analog values
    
    strcpy(query_buf, httpd->getQueryString(id));                       //copy transmitted parameters to query_buf
    strcpy(out_buf, io_header);                                         //initialize Website output
    
    io_webhandler_action(query_buf, strlen(query_buf));                 //handle transmitted parameters stored in query_buf
    


    strcpy(out_buf, analog_header);                                     //initialize Website output
    
    io_webhandler_action(query_buf, strlen(query_buf));                 //handle transmitted parameters
    
    /*create website in buffer*/
    strcat(out_buf,"<h1>Analog input</h1><div class=\"lf\"> <div class=\"block2\"><fieldset> ");
    strcat(out_buf, "<table class=\"form-table border-td\"><tr><th colspan=\"4\" class=\"center-align\">Analog Input</th></tr><tr class=\"center-align\"> <td>A1</td><td>A2</td><td>A3</td><td>A4</td></tr><tr class=\"center-align\">");
    
    /*read analog ports and create text for website*/
    for(counter = 1; counter <= 4; counter++){
        strcat(out_buf,"<th>");
        analog_buf = read_adc(ASCII_analog + char(counter));            //loop over all analog ports
        sprintf(tempstring,"%hu mv</th>",analog_buf);
        strcat(out_buf,tempstring);
    }
    strcat(out_buf,"</tr> </table></div>"); 
          
    strcat(out_buf, io_footer);                                         //copy footer to buffer
    
        #if defined debug
            printf("html length: %i \r\n",strlen(out_buf));
        #endif
    httpd->send(id, out_buf, strlen(out_buf), "Content-Type: text/html\r\n");   //send constructed website
    
}



/*---------------------------------------------------------------------------*
 * Routine:  io_webhandler_action
 *---------------------------------------------------------------------------*
 * Description:
 *      Routine to parse and handle http "get-requests" for dynamic
 *      generated websites.
 *
 *          eg. toggling output port 3: 
 *          http://mbed.ip/dynamic/websitename.htm?p30
 *          -> set port value of port 3 to 0
 *          
            eg. "o2" toggles output port 2
 *
 *      Supported Variables:
 *          o = toggle output port
 *          p = set bit to value
 *
 * Inputs:
 *      char* query_buf         -- pointer to string with http get request variables
 *      int query_buf_len       -- length of request string
 * Outputs:
 *      int                     -- port value (normally 0 or 1) 
 *                                  and in case of an error "-1"
 *---------------------------------------------------------------------------*/
int io_webhandler_action(char *query_buf, int query_buf_len){
    char io_action = 0;                                                     //variables to store parameters
    char io_port = 0;
    char io_value = 0;
    
    #if defined debug
        printf ("io_webhandler - querystring: %s string-lenth: %i\r\n", query_buf, query_buf_len);
    #endif
    
    if (query_buf_len >= 3){                                                //evaluate io-action parameters
        sscanf(query_buf, "%c%c%c", &io_action, &io_port, &io_value);       //3 or more parameters
    }else if (query_buf_len == 2){                                          //2 parameters
        sscanf(query_buf, "%c%c", &io_action, &io_port);
    }
    
    #if defined debug
        printf("io_webhandler: evaluated http-params %c %c %c \r\n",io_action, io_port, io_value);
    #endif
    
    switch (io_action){
        case('o'): if (io_port != 0)return toggle_port(io_port);                                //toggle output port
        break;
        case('p'): if ((io_port != 0) && (io_value != 0)){return write_portval(io_port,0);}     //set output port value
        break;
    }   
    return -1;                                                              //return -1 if no valid action should be done
}


/* =================================================================== */
/*      functions for hardware abstraction                             */
/* =================================================================== */


/* analog and digital ports are specified by ascii characters:
 *
 *   digital input 1 = a
 *   digital input 2 = b
 *   digital input 3 = c
 *   digital input 4 = d
 *   
 *   digital output 1 = 1
 *   digital output 2 = 2
 *   digital output 3 = 3
 *   digital output 4 = 4
 *
 * eg. read_portval("b") reads the value of the digital input port 2    
 */



/*---------------------------------------------------------------------------*
 * Routine:  read_portval
 *---------------------------------------------------------------------------*
 * Description:
 *      Reads a value of an io-port and returns its value. (logically correct)
 * Inputs:
 *      char port_name          -- ascii character representing the port
 * Outputs:
 *      int                     -- port value (normally 0 or 1) 
 *                                  and in case of an error "-1"
 *---------------------------------------------------------------------------*/
int read_portval(char port_name){
    switch (port_name){
        case (ASCII_out + 1): if(out1){ return 0;} else{ return 1;}
        case (ASCII_out + 2): if(out2){ return 0;} else{ return 1;}
        case (ASCII_out + 3): if(out3){ return 0;} else{ return 1;}
        case (ASCII_out + 4): if(out4){ return 0;} else{ return 1;}
        case (ASCII_out + 5): return relay1;
        case (ASCII_out + 6): return led1;
        case (ASCII_out + 7): return led2;
        case (ASCII_out + 8): return led3;
        case (ASCII_out + 9): return led4;
        case (ASCII_in + 0): if(in1){ return 0;} else{ return 1;}
        case (ASCII_in + 1): if(in2){ return 0;} else{ return 1;}
        case (ASCII_in + 2): if(in3){ return 0;} else{ return 1;}
        case (ASCII_in + 3): if(in4){ return 0;} else{ return 1;}
        }
    return -1;
}

//
/*---------------------------------------------------------------------------*
 * Routine:  write_portval
 *---------------------------------------------------------------------------*
 * Description:
 *      Function to set output port values (handles inverted logic).
 * Inputs:
 *      char port_name          -- ascii character representing the port
 *      int port_val            -- output value
 * Outputs:
 *      int                     -- given port value (normally 0 or 1) 
 *                                  and in case of an error "-1"
 *---------------------------------------------------------------------------*/
int write_portval(char port_name, int port_val){
    if (port_val > 1) return 0;                     //no analog/pwm signal output yet, only 0 and 1
    
        #if defined debug
            printf("function write_portval: port %c value %i \r\n",port_name, port_val);
        #endif
        
    switch (port_name){
        case (ASCII_out + 1): if(port_val){ out1 = 0; return 0;} else{ out1 = 1; return 1;}     //inverted output logic
        case (ASCII_out + 2): if(port_val){ out2 = 0; return 0;} else{ out2 = 1; return 1;}     //inverted output logic
        case (ASCII_out + 3): if(port_val){ out3 = 0; return 0;} else{ out3 = 1; return 1;}     //inverted output logic
        case (ASCII_out + 4): if(port_val){ out4 = 0; return 0;} else{ out4 = 1; return 1;}     //inverted output logic
        case (ASCII_out + 5): relay1 = port_val; return relay1;                                     //relay port
        case (ASCII_out + 6): led1 = port_val; return led1;
        case (ASCII_out + 7): led2 = port_val; return led2;
        case (ASCII_out + 8): led3 = port_val; return led3;
        case (ASCII_out + 9): led4 = port_val; return led4;
        }
    return -1; 
}


/*---------------------------------------------------------------------------*
 * Routine:  toggle_port
 *---------------------------------------------------------------------------*
 * Description:
 *      Function to toggle output ports.
 * Inputs:
 *      char port_name          -- ascii character representing the port
 * Outputs:
 *      int                     -- new port value (normally 0 or 1) 
 *                                  and in case of an error "-1"
 *---------------------------------------------------------------------------*/
int toggle_port(char port_name){
        #if defined debug
            printf("function toggle_port: toggle port %c \r\n",port_name);
        #endif
    switch (port_name){
        case (ASCII_out + 1): out1 = !out1; return out1;
        case (ASCII_out + 2): out2 = !out2; return out2;
        case (ASCII_out + 3): out3 = !out3; return out3;
        case (ASCII_out + 4): out4 = !out4; return out4;
        case (ASCII_out + 5): relay1 = !relay1; return relay1;
        case (ASCII_out + 6): led1 = !led1; return led1;
        case (ASCII_out + 7): led2 = !led2; return led2;
        case (ASCII_out + 8): led3 = !led3; return led3;
        case (ASCII_out + 9): led4 = !led4; return led4;      
        }
    return -1; 
}

/*---------------------------------------------------------------------------*
 * Routine:  read_adc
 *---------------------------------------------------------------------------*
 * Description:
 *      Function to read the integrated adc-ports and calculate the input
 *       voltage in millivolts.
 *
 * Inputs:
 *      char port_name          -- ascii character representing the port
 * Outputs:
 *      unsigned short          -- input voltage in milivolt 
 *---------------------------------------------------------------------------*/
unsigned short read_adc(char port_name){
    unsigned int adc_tempval = 0;                   //32 bit buffer for analog value
    
    /*read raw analog port value*/
    switch (port_name){
        case (ASCII_analog + 1): adc_tempval = ain1.read_u16();
        break;
        case (ASCII_analog + 2): adc_tempval = ain2.read_u16();
        break;
        case (ASCII_analog + 3): adc_tempval = ain3.read_u16();
        break;
        case (ASCII_analog + 4): adc_tempval = ain4.read_u16();
        break;
        default: return 0;
    }
        
    /*  calculate the analog input voltage (input voltage is divided by 3.5):
    
        The reference voltage of 3.3V (3300mV) is diveded into 2^16 steps.
        Result in millivolts: Vin_mbed = (3300 * ADC_Value)/65536
        mbedRail24v uses a voltage divider: Vin_mbedrail24v = Vin_mbed * 3,5
        -> Vin_mbedrail= (3300 * ADC_Value * 3,5)/65536
        an integer of 32 bit is required for the calculation, otherwise the multiplication would fail
    */
    
    adc_tempval *= 11550;                                   // ADC_Value * 3300 * 3,5
    adc_tempval /= 0xFFFF;                                  // divide by 65536 (0xFFFF)
    
    return (unsigned short)adc_tempval;                     //return the calculated value of an analog port in milivolt
}