#ifndef NRF51_RTC_H
#define NRF51_RTC_H

#include <time.h>

class nrf51_rtc {
    // class to create equivalent of time() and set_time()
    //   ...depends upon RTC1 to be running and to never stop -- a byproduct of instantiation of mbed library's "ticker"
public:
    nrf51_rtc();
    time_t time();
    int set_time(time_t rawtime);
    
    static void update_rtc(); // similar to "time" but doesn't return the value, just updates underlying variables

    // these should be private
private:
    time_t time_base;
    unsigned int rtc_previous;
    const unsigned int ticks_per_second;
};

extern nrf51_rtc rtc;

#endif //!NRF51_RTC_H
