#include "mbed.h"
#include "BME280.h"
#ifdef TARGET_UBLOX_C027
 #include "C027_api.h"
#else
 #error "This example is targeted for the C027 platform"
#endif

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
I2C i2c(P0_0, P0_1);
BME280 sensor(i2c);

int main() {
    float temp = 0;
    float pres = 0;
    float humid = 0;

        
    sensor.initialize();
    while(1) {
        myled = !myled;
        wait(0.2);
        temp = sensor.getTemperature();
        pres = sensor.getPressure();
        humid = sensor.getHumidity();
        pc.printf("temp: %f, pres: %f, humid: %f\n", temp, pres, humid);
    }    
}