#include "mbed.h"
#include "TextLCD.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "thread_functions.hpp"
#include "SD_functions.hpp"
#include "peripherals.hpp"
#include "Network.hpp"
#include "time_functions.hpp"



//Serial pc(SERIAL_TX, SERIAL_RX);

Thread sensor_thread(osPriorityRealtime);    //sensor thread is highest priority
Thread serial_thread(osPriorityNormal);    
Thread SD_Card_thread(osPriorityNormal); 
Thread Network_thread(osPriorityNormal);
Thread Update_time_thread(osPriorityNormal);
Thread Print_thread(osPriorityNormal);


//Main thread
int main() {
    
    //Power On Check TODO
    lcd.cls();
    
    //FunctionSD1();
    
    // run threads
    sensor_thread.start(FunctionSensor);           
    serial_thread.start(FunctionSerial); 
    SD_Card_thread.start(FunctionSD1);
    Network_thread.start(Network);   
    Update_time_thread.start(UpdateTime);

}
