//http://www.cplusplus.com/reference/cstring/strcmp/

#include "mbed.h"
#include <iostream>
#include <string> 
#include <stdio.h>
#include <ctype.h>
#include <sstream>

//Digital outputs
DigitalOut onBoardLED(LED2);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);

char rxBuffer[80];
char puttyNum[20];

char i = 0;
char c = 0;

int puttyRes;
float puttyFloat;

// commands
string command = "READ ALL";
string command2 = "DELETE ALL";
string command3 = "READ";
int readN;
string command4 = "DELETE";
int deleteN = 0;
string command5 = "SETDATE";
int setDay = 0;
int setMonth = 0;
int setYear = 0;
string command6 = "SETTIME";
int setHour = 0;
int setMinute = 0;
int setSecond = 0;
string command7 = "SETT";
float Tmin = 0.1;
float setT;
string command8 = "STATE";
bool stateX = false;
string command9 = "LOGGING";
bool logX = false;


RawSerial pc(USBTX, USBRX, 9600);
Thread serialRX(osPriorityNormal);

// Rx Interupt routine
void Rx_interrupt(){
    pc.attach(NULL, Serial::RxIrq);     // Disable Rx interrupt
    serialRX.signal_set(0xA);                   // Set signal for Rx thread
}

// Read received chars from UART
void rx_thread(){
    while (true) {
        Thread::signal_wait(0xA);
        Thread::signal_clr(0xA);
        //memset(rxBuffer, 0, sizeof(rxBuffer));
        while (pc.readable()) {
            c = pc.getc();
            rxBuffer[i] = c; 
            i = i + 1;
            yellowLED = !yellowLED;
        }
        
        pc.attach(&Rx_interrupt);         // Enable Rx interrupt
        redLED = !redLED;
        
   
        
        if (c == '\r') {
            
            greenLED = !greenLED;
            string rxBufferSTR = rxBuffer;
            int c = rxBufferSTR.length();
 
            pc.printf("rxBuffer: %srxBuffer size: %d\n", rxBuffer, c);

            // Command check here

            if (rxBufferSTR.find(command) != string::npos) {
                pc.printf("Command READ ALL\n");
            }
            else if (rxBufferSTR.find(command2) != string::npos){
                pc.printf("Command DELETE ALL\n");
                //FOO
                pc.printf("DELETED N RECORDS\n");
                }
            else if (rxBufferSTR.find(command3) != string::npos){
                pc.printf("Command READ\n");
                
                // for commands with numbers
                int commandSize = command3.length();
                pc.printf("size of key %d\n", commandSize);
                int j=0;
                for(i=commandSize+1; i<c; i++) {
                    puttyNum[j] = rxBuffer[i];
                    j = j + 1;
                    if (j > 2) {
                        break;
                    }
                }
                pc.printf("puttyNum %s\n", puttyNum);
                stringstream ss;
                for (int z = 0; z < sizeof(puttyNum) / sizeof(puttyNum[0]); z++) {
                    ss << puttyNum[z];
                }
                ss >> readN;
                printf("Reading %i records\n", readN);
                }
            else if (rxBufferSTR.find(command4) != string::npos){
                pc.printf("Command DELETE\n");
                 // for commands with numbers
                int commandSize = command4.length();
                pc.printf("size of key %d\n", commandSize);
                int j=0;
                for(i=commandSize+1; i<c; i++) {
                    puttyNum[j] = rxBuffer[i];
                    j = j + 1;
                    if (j > 2) {
                        break;
                    }
                }
                pc.printf("puttyNum %s\n", puttyNum);
                stringstream ss;
                for (int z = 0; z < sizeof(puttyNum) / sizeof(puttyNum[0]); z++) {
                    ss << puttyNum[z];
                }
                ss >> deleteN;
                printf("DELETED %i RECORDS\n", deleteN);
                }
            else if (rxBufferSTR.find(command5) != string::npos){
                pc.printf("Command SETDATE\n");
                 // for commands with numbers
                int commandSize = command5.length();
                pc.printf("size of key %d\n", commandSize);
                int j=0;
                for(i=commandSize+1; i<c; i++) {
                    puttyNum[j] = rxBuffer[i];
                    j = j + 1;
                    if (j > 10) {
                        break;
                    }
                }
                pc.printf("puttyNum %s\n", puttyNum);
                stringstream ss;
                for (int z = 0; z < sizeof(puttyNum) / sizeof(puttyNum[0]); z++) {
                    ss << puttyNum[z];
                    pc.printf("%c", puttyNum[z]);
                }
                ss >> setDay;             
                ss >> setMonth;
                ss >> setYear;
                printf("DATE UPDATED TO %i.%i.%i\n", setDay, setMonth, setYear);
                }
            else if (rxBufferSTR.find(command6) != string::npos){
                pc.printf("Command SETTIME\n");
                 // for commands with numbers
                int commandSize = command6.length();
                pc.printf("size of key %d\n", commandSize);
                int j=0;
                for(i=commandSize+1; i<c; i++) {
                    puttyNum[j] = rxBuffer[i];
                    j = j + 1;
                    if (j > 10) {
                        break;
                    }
                }
                pc.printf("puttyNum %s\n", puttyNum);
                stringstream ss;
                for (int z = 0; z < sizeof(puttyNum) / sizeof(puttyNum[0]); z++) {
                    ss << puttyNum[z];
                }
                ss >> setHour;
                ss >> setMinute;
                ss >> setSecond;
                printf("TIME UPDATED TO %i.%i.%i\n", setHour, setMinute, setSecond);
                }
            else if (rxBufferSTR.find(command7) != string::npos){
                pc.printf("Command SETT\n");
                // for commands with numbers
                int commandSize = command7.length();
                pc.printf("size of key %d\n", commandSize);
                int j=0;
                for(i=commandSize+1; i<c; i++) {
                    puttyNum[j] = rxBuffer[i];
                    j = j + 1;
                    if (j > 3) {
                        break;
                    }
                }
                pc.printf("puttyNum %s\n", puttyNum);
                stringstream ss;
                for (int z = 0; z < sizeof(puttyNum) / sizeof(puttyNum[0]); z++) {
                    ss << puttyNum[z];
                }
                ss >> puttyFloat;
                printf("puttyFloat %6.4f\n", puttyFloat);
                
                if ((Tmin <= puttyFloat) && ( puttyFloat <= 60)) {
                    setT = puttyFloat;
                    printf("T UPDATED TO %6.4f\n", setT);
                    }
                else {
                    printf("TIME OUT OF RANGE\n");    
                    }
                    
                }
            else if (rxBufferSTR.find(command8) != string::npos){
                pc.printf("Command STATE\n");
                stateX = !stateX;
                printf("SAMPLING %i\n", stateX);
                
                }
            else if (rxBufferSTR.find(command9) != string::npos){
                pc.printf("Command LOGGING\n");
                logX = !logX;
                printf("LOGGING %i\n", logX);
                }
            else {
                pc.printf("Command not found.\n");
            }

            memset(puttyNum, 0, sizeof(puttyNum));
            memset(rxBuffer, 0, sizeof(rxBuffer)); //only reset after strcmp
            i = 0;
        }
  }
    
}


int main() {
    
    serialRX.start(rx_thread);      //start serial interrupt thread
    pc.attach(&Rx_interrupt);           //attach interrupt function that triggers when data is available
    pc.printf("Please enter command in full caps\n");
    while(1) {
        Thread::wait(2500);
    }
    
}
