#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include <iostream>
#include <string> 

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY1 ""                                    \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Team-Q Elec351</h1>" "\r\n"                           \
"       <p>Time : "                                              \

#define HTTP_MESSAGE_BODY2 ""                                    \
        "&nbsp Date : "                                          \

#define HTTP_MESSAGE_BODY3 ""                                    \
       "</p>" "\r\n"                                             \
"      <p>Light levels are : "   "\r\n"                          \

#define HTTP_MESSAGE_BODY4 ""                                    \
        "</p>" "\r\n"                                            \
"       <p>Current Temperature : " "\r\n"                        \
        
#define HTTP_MESSAGE_BODY5 ""                                    \
        "</p>" "\r\n"                                            \
"       <p>Current Pressure : " "\r\n"                           \
        
#define HTTP_MESSAGE_BODY6 ""                                    \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

#define IP        "10.0.0.10"
#define NETMASK   "255.0.0.0"
#define GATEWAY   "10.0.0.1"

AnalogIn ldr(PA_0);


int main()
{
    printf("Basic HTTP server example\n");
    
    //Configure an ethernet connection
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
    printf("The target IP address is '%s'\n", eth.get_ip_address());
    
    //Now setup a web server
    TCPServer srv;           //TCP/IP Server
    TCPSocket clt_sock;      //Socket for communication
    SocketAddress clt_addr;  //Address of incoming connection
    
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
    while (true) {
        using namespace std;
        //Block and wait on an incoming connection
        srv.accept(&clt_sock, &clt_addr);
        printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        
        //Uses a C++ string to make it easier to concatinate
        //"response" is the string that makes up the whole web page
        string response;
        //This is a C string
        //make space to save variables as strings
        char time_str[64];
        char date_str[64];
        char ldr_str[64];
        char temp_str[64];
        char pres_str[64];
        
        //Read the time/date/sensor values
        //use sensor readings instead of 10's
        float a = 10;
        float e = 10;
        float i = ldr;
        float o = 10;
        float u = 10;
        
        //Convert to a C String
        sprintf(time_str, "%5.3f", a );
        sprintf(date_str, "%5.3f", e );
        sprintf(ldr_str, "%5.3f", i );
        sprintf(temp_str, "%5.3f", o );
        sprintf(pres_str, "%5.3f", u );
        
        //Build the C++ string response
        response = HTTP_MESSAGE_BODY1;
        response += time_str;
        response += HTTP_MESSAGE_BODY2;
        response += date_str;
        response += HTTP_MESSAGE_BODY3;
        response += ldr_str;
        response += HTTP_MESSAGE_BODY4;
        response += temp_str;
        response += HTTP_MESSAGE_BODY5;
        response += pres_str;
        response += HTTP_MESSAGE_BODY6;
                
        //Send static HTML response (as a C string)
        clt_sock.send(response.c_str(), response.size()+6);    
    }
}
