#include "mbed.h"

#include <string.h>
//#define BME
#ifdef BME
#include "BME280.h"
#else
#include "BMP280.h"
#endif


// Buffer
#include "buffer.hpp"
// LCD
#include "hardware_setup.hpp"

 
#define Signal 1

//Global objects
Serial pc(USBTX, USBRX);
AnalogIn LDR_In(A1);
DigitalOut led(D7);

DigitalOut led1(LED1);

//Threads
Thread t1(osPriorityRealtime);
Thread t2;

//The ticker, used to sample data at a fixed rate
Ticker t;


//Global Variables
float fLDR = 0.0; //probably don't want this global?
Mutex sensorLock;


//Environmental Sensor driver
#ifdef BME
BME280 sensor(D14, D15);
#else
BMP280 sensor(D14, D15);
#endif


// Function declarations
void FunctionSample();


void doCaptureSamples() {
    t1.signal_set(Signal);
}


void decrementBuffer(){
    while(true){
    float oldData = takeFromBuffer();  
    }
    
}


void FunctionSample()
{
    pc.printf("Testing with %d sample buffer", BUFFERSIZE);
    //pc.printf("%d\n", BUFFERSIZE);
    while (true) {
        Thread::signal_wait(Signal);
        led1 = !led1;
   
        sensorLock.lock();   
        
        // Read LDR
        fLDR = LDR_In;
        pc.printf("LDRinThread = %6.4f\n", fLDR);
        
        //Read BMP280 Sensors (I2C)
        float temp = sensor.getTemperature();
        float pressure = sensor.getPressure();
        //Display in PuTTY
        pc.printf("Temperature: %5.1f\n", temp);
        pc.printf("Pressure: %5.1f\n", pressure);
        
        addToBuffer(fLDR);
        addToBuffer(temp);
        addToBuffer(pressure);

        // date and time
        int year = LCD.year;
        char month = LCD.month;
        char day = LCD.day;
        char hour = LCD.hours;
        char minute = LCD.minutes;
        
        char DaT[100];
        int n; 
        n=sprintf (DaT, "%d.%d.%d %d:%d Data Temp:%5.1f Pressure:%5.1f LDR:%6.4f", year, month, day, hour, minute, temp, pressure, fLDR);
        pc.printf ("[%s] is a string %d chars long\n",DaT,n);
        //addToBuffer(DaT); CHANGE addToBuffer to char, as now we only need to put in DaT, which is a char
        
        
        
        sensorLock.unlock();
        

    }
}


//Main function
int main()
{
    
    t1.start(FunctionSample);
    t2.start(decrementBuffer);
    
    //Ticker in seconds
    t.attach(&doCaptureSamples, 1);
    
    
    //Set PuTTY baud rate to 9600
    pc.baud(9600);
 
    while(1) {
 
        //Displauy the LDR
        //ldrLock.lock();
        //float _ldr = fLDR;
        //ldrLock.unlock();
        //pc.printf("LDR = %6.4f\n", _ldr);
        Thread::wait(3000);
        
        // make scheduler put the board to sleep until a signal is set?
        //Thread::wait(osWaitForever);
 
    } //end while(1)
} //end main