#include "mbed.h"
#include "LCD.h"

int setInt = 0;
Ticker T;

NewLCD::NewLCD(PinName RS, PinName E, PinName D0, PinName D1, PinName D2, PinName D3) : _RS(RS),_E(E), _D(D0, D1, D2, D3) {    

    _E = 0;
    wait(0.000040f);
    _E = 1;
    _RS = 0;                //Command mode
    
    wait(0.015);            //Wait 15ms to ensure device is powered
    
    for (int i=0; i<3; i++) {
        writeByte(0x03);    //set DDRAM address to 0. Do this multiple times
        wait(0.00164);  
    }
    
    writeByte(0x2);         //4-bit mode. Not sure how this sets bits 5 & 4 when we shift them using writeByte. 0010 0000 or 0000 0010?
    wait(0.000040f);        
        
    writeCommand(0x28);     //4-bit mode, 2 lines, 5x8 dots.    0010 1000
    writeCommand(0x0F);     //display on, cursor off, blinking cursor off.  0000 1100  (0x0C for nomral operation, 0x0F for everything on)
    writeCommand(0x06);      //cursor moves to right when displaying text.   0000 0110
    wait(0.00152);
    
    hours = 0;
    minutes = 0;
    day = 0;
    month = 0;
    year = 2017;
    firstSet = true;
    
}

void NewLCD::charDisp(int column, int row, char c) {
    int addr = DDRAMAddress(column, row);
    writeCommand(addr);
    writeData(c);
}

int NewLCD::DDRAMAddress(int column, int row) {
    return (0x80 + (row * 0x40) + column);
}

void NewLCD::cursorLocation(int column, int row) {
    _column = column;
    _row = row;
}

void NewLCD::shiftCursor(string direction) {
    if (direction == "right") {         //shift to right
        writeCommand(0x14);         //0001 0100
    } else if (direction == "left") {  //shift to left
        writeCommand(0x10);         //0001 0000
    }
}

void NewLCD::clearScreen() {
    writeCommand(0x01);         //clear screen and set cursor to 0
    wait(0.00164f);             //this command takes 1.64 ms
    cursorLocation(0, 0);
}

int NewLCD::_putc(int txt) {
    if (txt == '\n') {
        _column = 0;
        _row++;
        if (_row >= 2) {
            _row = 0;
        }
    } else {
        charDisp(_column, _row, txt);
        _column++;
        if (_column >= 16) {
            _column = 0;
            _row++;
            if (_row >= 2) {
                _row = 0;
            }
        }
    }
    return txt;
}
int NewLCD::_repc(int txt) {
    if (txt == '\n') {
        _column = 0;
        _row++;
        if (_row >= 2) {
            _row = 0;
        }
    } else {
        charDisp(_column, _row, txt);
        if (_column >= 16) {
            _column = 0;
            _row++;
            if (_row >= 2) {
                _row = 0;
            }
        }
    }
    return txt;
}


int NewLCD::_getc() {
    return -1;
}

void NewLCD::writeByte(char byteToSend) {
    _D = byteToSend >> 4;
    wait(0.000040f); // most instructions take 40us
    _E = 0;
    wait(0.000040f);
    _E = 1;
    _D = byteToSend >> 0;
    wait(0.000040f);
    _E = 0;
    wait(0.000040f);  // most instructions take 40us
    _E = 1;
}

void NewLCD::writeCommand(char commandToSend) {
    _RS = 0;
    writeByte(commandToSend);
}

void NewLCD::writeData(char dataToSend) {
    _RS = 1;
    writeByte(dataToSend);
}

void NewLCD::setDateAndTime(int sw1s, int sw2s) {
        
        clearScreen();
        printf("Time: %d:%d\n", hours, minutes);
        printf("Date: %d/%d/%d", day, month, year);
        if(sw1s == 1){
            wait(0.2);
            setInt = setInt + 1;
            if(setInt >= 5) {
                setInt = 1;
                }
            }
        
        switch(setInt){
            case 1:
                if(sw2s == 1) {
                    wait(0.2);
                    minutes = minutes + 1;
                    if(minutes >= 60) {
                        minutes = 0;
                        }

                    }
                    break;
            case 2:
                if(sw2s == 1) {
                    wait(0.2);
                    hours = hours + 1;
                    if(hours >= 24) {
                        hours = 0;
                        }

                    }
                    break;
            case 3:
            
                if(sw2s == 1) {
                    wait(0.2);
                    month = month + 1;
                    if(month >= 12) {
                        month = 0;
                        }

                    }

                    break;
            case 4:
                if(sw2s == 1) {
                    wait(0.2);
                    day = day + 1;
                    if(day >= 31) {
                        day = 0;
                        }

                    }
                    break;
            default:
                    break;
}

}
    void NewLCD::updateClock() {
    minutes = minutes + 1;
    if(minutes >= 60) {
        minutes = 0;
        hours = hours + 1;
        if(hours >= 24) {
            hours = 0;
            day = day + 1;
                if(day >= 31) {
                    day = 0;
                    month = month + 1;
                    if(month >= 12) {
                        month = 0;
                        }
                }           
        }        
    }
        clearScreen();
        printf("Time: %d:%d\n", hours, minutes);
        printf("Date: %d/%d/%d", day, month, year);
}

void NewLCD::startClock() {
    T.attach(this, &NewLCD::updateClock, 60);
}
    

    
