#include "mbed.h"
#include <string>

class NewLCD : public Stream {
    
    public:
    
        /*  Create a new LCD interface
        
        RS      :   Intruction/data register control pin. 0 = Instruction register. 1 = Data register.
        E       :   Start data read/write.
        D0-3    :   Data lines.
        
        */
        NewLCD(PinName RS, PinName E, PinName D0, PinName D1, PinName D2, PinName D3);
        
        /*  Write a character to the display
        
        c   :   The character to display
        
        */
        //int putc(int txt);
        
        /*  Write a string to the display
        
        stringToDisplay  :  A string to display on the LCD, followed by potential variables that are
                            used in the string.
                            
        */        
        //int printf(const char* stringToDisplay, ...);
        
        /*  Move starting point of where the display will start printing
        
        column  :   The horizontal position from the left, starting at 0
        row     :   The row selection from the top, starting at 0
        
        */
        void cursorLocation(int column, int row);
        
        /*  Clear the screen    */
        void clearScreen();
        
        /*  Function to shift the cursor left or right. 0 for left, 1 for right */
        void shiftCursor(string direction);
        
        /*  Variables used to set the time and date */
        char hours;
        char minutes;
        char day;
        char month;
        int year;
        
        /*  Function to set the time and date using the switches    */
        void setDateAndTime(int sw1s, int sw2s);
        void updateClock();
        void startClock();
        
    protected:
    
        //Function to print characters. This gets called from printf.
        virtual int _putc(int txt);
        virtual int _getc();
        virtual int _repc(int txt);
    
        //Sets DDRAM Address (this corresponds to the cursor location)
        int DDRAMAddress(int column, int row);
        
        //Function to write a single character to the display in a given location
        void charDisp(int column, int row, char c);
        
        //Function to send information down the data lines to instruction/data register
        void writeByte(char byteToSend);
        
        //Function to set RS pin low and call writeByte to send command
        void writeCommand(char commandToSend);
        
        //Function to set RS pin high and call writeByte to send data
        void writeData(char dataToSend);
        
        
        DigitalOut _RS, _E;
        BusOut _D;
        
        int _column;
        int _row;
        
        bool firstSet;
        
};
        
    