#include "mbed.h"
#include "hardware_setup.hpp"

#define RED_DONE 1
#define YELLOW_DONE 2

//Digital outputs
DigitalOut onBoardLED(LED1);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);

//Inputs
DigitalIn  onBoardSwitch(USER_BUTTON);
DigitalIn  SW1(PE_14);
DigitalIn  SW2(PE_12);
//Serial pc(USBTX, USBRX);
AnalogIn adcIn(A0);

NewLCD LCD(PD_15, PF_12, PF_13, PE_9, PF_14, PF_15); // RS, E, D4-D7

//POWER ON SELF TEST
void post() 
{
    //POWER ON SELF TEST (POST)
    puts("ALL LEDs should be blinking");
    for (unsigned int n=0; n<10; n++) {
        redLED    = 1;
        yellowLED = 1;
        greenLED  = 1;
        wait(0.05);
        redLED    = 0;
        yellowLED = 0;
        greenLED  = 0;     
        wait(0.05);         
    } 
    
    //LCD Test
    for (unsigned int n=0; n<3; n++) {
        LCD.printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        wait(0.1);
        LCD.clearScreen();
        wait(0.1);
    } 
}