/*This module enables a user to communicate with the system using a serial
connection, commands can be sent using a terminal emulator
*/
#include "serial_protocol.hpp"
#include "sample_hardware.hpp"
#include <string>
#include <ctype.h>

#define SETT_UPPER_BOUND 60.0f  //upper bound for sampling period
#define SETT_LOWER_BOUND 0.1f   //lower bound for sampling period


Serial pc(SERIAL_TX, SERIAL_RX);


char string1[32];
char string2[32];

char dayStr[3];
char monthStr[3];
char yearStr[5];
char hourStr[3];
char minuteStr[3];
char secondStr[3];
int day;
int month;
int year;
int readSamples=0;
int deleteSamples=0;
float sampleRate=0;


//reads serial keyboard input from pc
void getData(){
    pc.scanf("%s %s", string1, string2);
    //pc.printf("%s %s\n",string1, string2); \\for debugging 
}

//compares strings received from getData function against available commands
//can alter global variables
void readSerial(){
    if((strcmp(string1,"READ")==0) && (strcmp(string2,"ALL")==0)){
        pc.printf("reading all\n");
    }
    
    else if((strcmp(string1,"DELETE")==0) && (strcmp(string2,"ALL")==0)){
        pc.printf("deleting all\n");
    }
    
    else if(strcmp(string1,"READ")==0){
        int num=0;
        sscanf(string2,"%d",&num);
                
        if(num>0){
            readSamples = num;
            pc.printf("reading <%d>\n",readSamples);
        }
        else{
            pc.printf("invalid value\n");
        }                
    }
    
    else if(strcmp(string1,"STATE")==0){
        if(strcmp(string2,"ON")==0){
            pc.printf("SAMPLING ON\n");
        }
        else if(strcmp(string2,"OFF")==0){
            pc.printf("SAMPLING OFF\n");
        }
        else{
            pc.printf("INVALID COMMAND\n");
        }
    }
    
    else if(strcmp(string1,"LOGGING")==0){
        if(strcmp(string2,"ON")==0){
            pc.printf("LOGGING ON\n");
        }
        else if(strcmp(string2,"OFF")==0){
            pc.printf("LOGGING OFF\n");
        }
        else{
            pc.printf("INVALID COMMAND\n");
        }
    }
    
    else if(strcmp(string1,"SETT")==0){
        float number=0;
        sscanf(string2,"%f",&number);
        if(number>=SETT_LOWER_BOUND && number<=SETT_UPPER_BOUND){
            sampleRate = number;
            pc.printf("sampling period set to %f\n",sampleRate);
        }
        else{
            pc.printf("invalid value\n");
        }                
    }
    
    else if(strcmp(string1,"DELETE")==0){
        int num=0;
        sscanf(string2,"%d",&num);
        
        if(num>0){
            deleteSamples=num;
            pc.printf("deleting <%d>\n",deleteSamples);
        }
        else{
                pc.printf("invalid value\n");
        }
    }
    
    else if(strcmp(string1,"SETDATE")==0) 
    {
        int validDigit=0;        
        int i;
        for(i=0;i<8;i++){ //check first 8 elements of array are digits
            if(isdigit(string2[i])){
                validDigit++;
            }
        }
        if(string2[8] == NULL){ //check element 8 of array is NULL, where the string terminates
            validDigit++;
        }               
            
        if(validDigit==9){ 
           
           dayStr[0] = string2[0];
           dayStr[1] = string2[1];
           dayStr[2] = NULL;
           monthStr[0] = string2[2];
           monthStr[1] = string2[3];
           monthStr[2] = NULL;
           yearStr[0] = string2[4];
           yearStr[1] = string2[5];
           yearStr[2] = string2[6];
           yearStr[3] = string2[7];
           yearStr[4] = NULL;
           //note if date is required in int form, use atoi() to convert from string to int    
            
           pc.printf("DATE UPDATED TO <%s><%s><%s>\n",dayStr,monthStr,yearStr);

        }
        else{
            pc.printf("invalid value\n");
        }
    }
    
        else if(strcmp(string1,"SETTIME")==0) 
    {
        int validDigit=0;        
        int i;
        for(i=0;i<6;i++){ //check first 8 elements of array are digits
            if(isdigit(string2[i])){
                validDigit++;
            }
        }
        if(string2[6] == NULL){ //check element 8 of array is NULL, where the string terminates
            validDigit++;
        }               
            
        if(validDigit==7){
           
           hourStr[0] = string2[0];
           hourStr[1] = string2[1];
           hourStr[2] = NULL;
           minuteStr[0] = string2[2];
           minuteStr[1] = string2[3];
           minuteStr[2] = NULL;
           secondStr[0] = string2[4];
           secondStr[1] = string2[5];
           secondStr[2] = NULL;    
            
           pc.printf("TIME UPDATE TO <%s><%s><%s>\n",hourStr,minuteStr,secondStr);
        }
        else{
            pc.printf("invalid value\n");
        }
    }
            
    else{
        pc.printf("invalid command\n");
    }
}
