#ifndef ENVELOPE_H
#define ENVELOPE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Envelope class
 * @author Luke Cartwright, University of Leeds
 * @brief converts output to env output
 * @date May 2020
*/

class Envelope
{
public://-----------------------------------------------------------------------
    //Methods
    /**Constructor*/
    Envelope();

    /**Destructior*/
    ~Envelope();

    /**Outputs unigned value with input modulated by ADS input variables
    *input -32767.>32767  Output 0->65535 
    * @returns a Unsigned Short corresponding to Envelope Output */
    uint16_t env_in(int a, int d, int s, int r, int in, bool init);
    
    /** Deals with the release part of the note
    *(triggered when note off button pressed) 
    * @Returns an Unsigned short (for release part) 
    * @Corresponding to envelope output */
    uint16_t release(int s, int r, int in, bool init);


private://----------------------------------------------------------------------
//variables
    uint16_t out; //main output variable
    int samples; //itterator for samples counter
    int samples_r; //release samples itterator
    int at; //incramented multiplier for output
    //ADSR variables multiplied up when applied to volume envelope
    int av;
    int dv;
    int sv;
    int rv;
    //Difference per sample variables
    int a_vec;
    int d_vec;
    int r_vec;


    //Methods
    /** Calculates the a_vec variable for use
    * (used as difference per sample in attack part of note) */
    int a_vector_calc(int av);
    
    /** Calculates the d_vec variable for use
    * (used as difference per sample in decay part of note)
    * Positive  only value */
    int d_vector_calc(int dv, int sv);
    
    /** Calculates the r_vec variable for use
    * (used as difference per sample in release part of note) 
    * Positive only value */
    int r_vector_calc(int sv, int rv);
};
#endif