/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Luke Cartwright
Username: el18loc
Student ID Number: 201225242
Start Date: 06/02/2020
Last Edited: 26/05/2020
*/

// Includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Menu.h"
#include "startup.h"
#include "Front.h"

#ifdef DEBUG
# include "Debug.h"
#endif

// Objects
Gamepad pad;
N5110 lcd;
Menu menu;
startup start;
Ticker tick;

//Functions
void noise_isr();

//Global Variables
volatile extern int g_isr_flag; //flag set by ISR for sound

int main()
{
    //printf("RUNNING CODE \n");
    start.initialise(lcd,pad); //initialises board and displays start screen
#ifdef DEBUG
    printf("DEBUG COMPILE RUNNING\n");
    run_LUTs_debug(); //debug value checking function
#endif
#ifdef SLOW_TIME 
    printf("Running in SLOW_TIME\n");
    tick.attach(&noise_isr, 1); //extended for debug (1Hz)
#endif
#ifdef CSV
    printf("Running CSV\n");
    tick.attach_us(&noise_isr, 5000); //extended for CV printfs (200Hz)
#endif
#ifndef SLOW_TIME 
#ifndef CSV //ATTACH TICKERS FOR SOUND
    tick.attach_us(&noise_isr, 100); //normal mode Fs=10kHz
#endif 
#endif
    while (1) { menu.mainmenu(lcd,pad); } //Main Menu
}

void noise_isr() { //Triggers Sound Generation
    #ifdef SLOW_TIME
    if (g_isr_flag==0) {
    //printf("ISR INTTERUPT = 1\n");
    }
    #endif
    g_isr_flag=1;
    }