#ifndef STARTUP_H
#define STARTUP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "LUTs.h"

/** startup class
 * @author Luke Cartwright, University of Leeds
 * @brief: manages startup and initialisation
 * @date May 2020
*/
//Global Variables
volatile extern uint16_t sin_wavtable[1024];
volatile extern uint16_t tri_wavtable[1024];
volatile extern uint16_t pulse_wavtable[1024];

class startup
{
public:
    //variables
    float fl; //frequency Variable

    //methods
    /** Constructor */
    startup();

    /** Destructior */
    ~startup();

    /** intitialsie function.
    * @Initialises all main gamepad components.
    * @Also Generates Preliminary LUTs
    */
    void initialise(N5110 &lcd, Gamepad &pad);

private://----------------------------------------------------------------------

};

#endif