#ifndef LUTs_H
#define LUTs_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** LUTs class
 * @author Luke Cartwright, University of Leeds
 * @brief generates LUTs
 * @date May 2020
*/

class LUTs
{
public:
    /** Constructor */
    LUTs();
    /** Destructior */
    ~LUTs();

    //Methods
    /** Generates all wavetables using preset central values
    * @genrates preset wavetables
    * @Outputs as global variables
    * @1024 Points per table (0->(2^16)-1)
    */ 
    void initial_wavetables();
    
    /**Generatres Sin Wavetable
    * @outputs Sin Wavetable as Global Variable
    */
    void sin_wavetable();
    
    /**Generatres Tri Wavetable
    * @outputs Tri Wavetable as Global Variable
    * @with defined PulseWidth
    */
    void tri_wavetable(int pulsewidth);
    
    /**Generatres Pulse Wavetable
    * @outputs Pulse Wavetable as Global Variable
    * @with defined PulseWidth
    */
    void pulse_wavetable(int pulsewidth);

private:
    //variables
    double rem; //Remainder (used for rounding)
    float sin_d; //Sin Double var
    uint16_t sin_u; //Sin Unsigned var
    float dif; //Difference required in Tri wav
    uint16_t dif_u; //Unsigned version of dif
    int i; //Itterator
    float rise_t; //Rise time for tri wav
    uint16_t rise_tu; //Unsigned version of rise_t
    uint16_t fall_tu; //unsigned measure of fall time for tri wav
    float up_t; //Time At max for square
    int up_tu; //Unsigned version of up_t
    
    //Methods
    /**Prints Certain Tri wavetable results for checking
    * @Multiples of 64 for tri_wav values for debug
    */
    void tri_wav_results();
};
#endif