#ifndef STARTMENU_H
#define STARTMENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ImpossEngine.h"

/** Start Menu Class
@author Lewis Cheadle
@brief Displays Start menu
@date May 2020
*/ 
class StartMenu
{

public:

    /* Constructor **/
    StartMenu();
    
    /* Destructor **/
    ~StartMenu();
    
    /** Draws the start menu and allows user to select what to do
        * @param lcd N5110 object
     */
    void complete(Gamepad &pad,N5110 &lcd);

    
private:
    
    /* Stores the value of the option that the user chooses  */
    int selector;
    
    /* Stores the sprite of the pointer so the user knows which option is
    selected */
    int arrow;
    
};
#endif