 #include "ImpossEngine.h"


ImpossEngine::ImpossEngine()
{

}

ImpossEngine::~ImpossEngine()
{

}

StartMenu _start;

//displays the start menu, initialises the ball and sets to level zero
void ImpossEngine::complete(Gamepad &pad,N5110 &lcd)
{
    level = 0;
    _start.complete(pad,lcd); 
    int x = 0;
    int y = 21;
    _ball.init(x,y);
}
 
//reads user input from the gamepad
void ImpossEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}

//Used to set the level to zero
void ImpossEngine::set_level_zero()
{
    level = 0;
}

//Draws the levels, obstacles and ball
void ImpossEngine::draw(N5110 &lcd,Gamepad &pad)
{
    // draw the elements in the LCD buffer
    // pitch   
    
    
    if (level == 0){
        _zero.draw(lcd);
    }

    if (level == 1){
        _one.draw(lcd);
    } 
    
    if (level == 2){
        _two.draw(lcd);
    }
    
    if (level == 3){
         _three.draw(lcd);
    }
    
    if (level == 4){
         _four.draw(lcd);
    }
    
    if (level == 5){
         _five.draw(lcd);
    }
    
    if (level == 6){
        while(1){
            lcd.clear();
            lcd.printString("  Well done!  ",0,0);
            lcd.printString(" You beat all ",0,1);
            lcd.printString("of the levels!",0,2);
            lcd.printString("Press reset to",0,3);
            lcd.printString("  try again!  ",0,4);
            pad.leds_on();
            wait(0.15);
            pad.leds_off();
            wait(0.15);
            lcd.refresh();
            }    
    }
         
    _ball.update(_d,pad);
    
    _ball.draw(lcd);

}

//Updates all parameters, checks for collisions and checks to see if the level
//has been completed
void ImpossEngine::update(Gamepad &pad,N5110 &lcd)
{
    check_collision(pad,lcd);
    
    check_finish(pad);
}    

//Checks every pixel around the ball, if any are "on"(1) then that is classed
//as a collision
void ImpossEngine::check_collision(Gamepad &pad,N5110 &lcd)
{
    int _x = 0;
    int _y = 0;
    int i = 0;
    int x_pos = _ball.get_ball_x_pos() - 1;
    int y_pos = _ball.get_ball_y_pos() - 1;
    bool collision = false;
    //check around ball to see if it has made contact with anything
    
    while(i < 3){
        
        i++;
        
        if(lcd.getPixel(x_pos + _x,y_pos + _y) == 1){
            collision = true;
            }
            
        _x ++;
        
    }
    
    i = 0;
     
    while(i < 3){
        
        i++;
        
        if(lcd.getPixel(x_pos + _x,y_pos + _y) == 1){
            collision = true;
            }
            
        _y ++;
        
    }
    
    i = 0;
    
    while(i < 3){
        
        i++;
        
        if(lcd.getPixel(x_pos + _x,y_pos + _y) == 1){
            collision = true;
            }
            
        _x --;
        
    }
    
    i = 0;
    
    while(i < 3){
        
        i++;
        
        if(lcd.getPixel(x_pos + _x,y_pos + _y) == 1){
            collision = true;
            }
            
        _y --;
        
    //death sequence
    if(collision == true){
        lcd.clear();
        lcd.printString("  You died! ",0,2);
        lcd.refresh();
        wait(0.1); 
        pad.leds_on();
        wait(0.2);
        pad.leds_off();
        wait(0.1);
        pad.leds_on();
        wait(0.2);
        pad.leds_off();
        
        //resets ball to start of level if a collision has been detected
        _ball.level_finish();
        }
    }
}

//Checks to see if the ball has reached the end of the level, if it has,
//increases the value of the level and sets the ball back to the beginning of
//the level
void ImpossEngine::check_finish(Gamepad &pad)
{
    
    int pos = _ball.get_ball_x_pos();
    
    if(pos >= 82){
        level++;
        _ball.level_finish();
        }
}
