#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Ball Class
@author Lewis Cheadle
@brief Controls the ball in the Impossible game 
@date May 2020
*/ 
class Ball
{

public:

    /** Constructor */
    Ball();
    
    /** Destructor */
    ~Ball();
    
    /** Initialises the ball
         * @param x initial X position of ball
         * @param y initial Y position of ball
         */
    void init(int x,int y);
    
    /** Draws the ball
         * @param lcd N5110 object
         */
    void draw(N5110 &lcd);
    
    /** Updates position of the ball
         * @param d Direction of the joystick
         * @param pad object
         */
    void update(Direction d,Gamepad &pad);
    
    /** Resets ball position of level is complete
         */
    void level_finish();
    
    /** Returns ball X co-ordinate
         */
    int get_ball_x_pos();
    
    /** Returns ball Y co-ordinate
         */
    int get_ball_y_pos();
    
private:

    /* sprite to store ball drawing */
    int ball;
    /* Stores ball X co-ordinate */
    int ball_x_pos;
    /* Stores ball Y co-ordinate */
    int ball_y_pos;

};
#endif