#include "Ball.h"

Ball::Ball()
{
 
}

Ball::~Ball()
{

}

//Initialises the ball sprite and the initial co-ords of the ball
void Ball::init(int x,int y)
{
    int ball[2][2] = {
    {1,1},
    {1,1},
    };
    ball_x_pos = x;
    ball_y_pos = y;

}

//Takes x and y co-ordinates and draws the ball at that position.
void Ball::draw(N5110 &lcd)
{
    lcd.drawSprite(ball_x_pos,ball_y_pos,2,2,(int *)ball);
}

//Takes the inputs of the gamepad and updates the x and y co-ords based on the
//direction of the joystick and whether button A has been pressed.
//Pressing A double the speed of the ball.
void Ball::update(Direction d,Gamepad &pad)
{
    
    if(d != CENTRE){
        
    if (d == S && ball_y_pos < 47){
        if(pad.A_held() == true){ball_y_pos++;}
        ball_y_pos++;
        }
    
    if (d == N && ball_y_pos > 1){
        if(pad.A_held() == true){ball_y_pos--;}
        ball_y_pos--;
        }
        
    if (d == E && ball_x_pos < 83){
        if(pad.A_held() == true){ball_x_pos++;}
        ball_x_pos++;
        }
    
    if (d == W && ball_x_pos > 0){
        if(pad.A_held() == true){ball_x_pos--;}
        ball_x_pos--;
        }
        
    if (d == SE && ball_y_pos < 47 && ball_x_pos < 83){
        if(pad.A_held() == true){ball_y_pos++;
        ball_x_pos++;}
        ball_x_pos++;
        ball_y_pos++;
        }
        
    if (d == NE && ball_y_pos > 1 && ball_x_pos < 83){
        if(pad.A_held() == true){ball_y_pos--;
        ball_x_pos++;}
        ball_x_pos++;
        ball_y_pos--;
        };
        
    if (d == NW && ball_x_pos > 0 && ball_y_pos > 1){
        if(pad.A_held() == true){ball_y_pos--;
        ball_x_pos--;}
        ball_x_pos--;
        ball_y_pos--;
        }
        
    if (d == SW && ball_x_pos > 0 && ball_y_pos < 47){
        if(pad.A_held() == true){ball_y_pos++;
        ball_x_pos--;}
        ball_x_pos--;
        ball_y_pos++;
        }
        
        }
        

    
}

//Functions to return the x and y co-ords of the ball
int Ball::get_ball_x_pos(){
    return ball_x_pos;
    }
    
int Ball::get_ball_y_pos(){
    return ball_y_pos;
    }

//When a level has been completed, resets the balls co-ords
void Ball::level_finish(){
    ball_x_pos = 0;
    ball_y_pos = 21;
    }